/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XmlComparerImpl
implements XmlComparer {
    private boolean commentsInsignificant = true;
    private Set<XmlComparer.CompareListener> compareListeners = new HashSet<XmlComparer.CompareListener>();

    @Override
    public void addCompareListener(XmlComparer.CompareListener listener) {
        this.compareListeners.add(listener);
    }

    @Override
    public void removeCompareListener(XmlComparer.CompareListener listener) {
        this.compareListeners.remove(listener);
    }

    private boolean definesNamespace(Attr attr) {
        if (attr.getNodeName().startsWith("xmlns:")) {
            return true;
        }
        return attr.getNodeName().equals("xmlns");
    }

    boolean useNode(Node node) {
        if (this.commentsInsignificant && node instanceof Comment) {
            return false;
        }
        if (node instanceof Attr && this.definesNamespace((Attr)node)) {
            return false;
        }
        for (XmlComparer.CompareListener listener : this.compareListeners) {
            if (listener.useNode(node)) continue;
            return false;
        }
        return true;
    }

    boolean attributeDefined(Attr anAttr, NamedNodeMap attributes) {
        String bValue;
        String aName = anAttr.getNodeName();
        Node bAttribute = attributes.getNamedItem(aName);
        if (bAttribute == null) {
            return false;
        }
        String aValue = anAttr.getNodeValue();
        return aValue.equals(bValue = bAttribute.getNodeValue());
    }

    private boolean attributesDefined(NamedNodeMap subset, NamedNodeMap superset) {
        int length = subset.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)subset.item(i);
            if (!this.useNode(attr) || this.attributeDefined(attr, superset)) continue;
            return false;
        }
        return true;
    }

    private boolean areAttributesSame(NamedNodeMap a, NamedNodeMap b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        if (b == null) {
            return false;
        }
        if (!this.attributesDefined(a, b)) {
            return false;
        }
        return this.attributesDefined(b, a);
    }

    @Override
    public boolean areAttributesSame(Node a, Node b) {
        NamedNodeMap bAttributes;
        if (a == b) {
            return true;
        }
        NamedNodeMap aAttributes = a.getAttributes();
        if (aAttributes == (bAttributes = b.getAttributes())) {
            return true;
        }
        if (aAttributes == null) {
            return false;
        }
        if (bAttributes == null) {
            return false;
        }
        return this.areAttributesSame(aAttributes, bAttributes);
    }

    private Node skipUnusedNodes(Node node) {
        while (node != null && !this.useNode(node)) {
            node = node.getNextSibling();
        }
        return node;
    }

    private boolean checkChildren(Node a, Node b) {
        Node aChild = a.getFirstChild();
        aChild = this.skipUnusedNodes(aChild);
        Node bChild = b.getFirstChild();
        bChild = this.skipUnusedNodes(bChild);
        while (aChild != null && bChild != null) {
            if (!this.areNodesSame(aChild, bChild)) {
                return false;
            }
            aChild = aChild.getNextSibling();
            bChild = bChild.getNextSibling();
            aChild = this.skipUnusedNodes(aChild);
            bChild = this.skipUnusedNodes(bChild);
        }
        return aChild == null && bChild == null;
    }

    private boolean isNamespaceSame(Node a, Node b) {
        String bNamepace;
        String aNamepace = a.getNamespaceURI();
        if (aNamepace == (bNamepace = b.getNamespaceURI())) {
            return true;
        }
        if (aNamepace == null || bNamepace == null) {
            return false;
        }
        return aNamepace.equals(bNamepace);
    }

    @Override
    public boolean areNodesSame(Node a, Node b) {
        String bNodeValue;
        String aNodeValue;
        String bNodeName;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        boolean useA = this.useNode(a);
        boolean useB = this.useNode(b);
        if (!useA && !useB) {
            return true;
        }
        if (useA != useB) {
            return false;
        }
        if (a.getNodeType() != b.getNodeType()) {
            return false;
        }
        if (!this.isNamespaceSame(a, b)) {
            return false;
        }
        String aNodeName = XmlUtils.getName(a);
        if (aNodeName != (bNodeName = XmlUtils.getName(b))) {
            if (aNodeName == null) {
                return false;
            }
            if (bNodeName == null) {
                return false;
            }
            if (!aNodeName.equals(bNodeName)) {
                return false;
            }
        }
        if ((aNodeValue = a.getNodeValue()) != (bNodeValue = b.getNodeValue())) {
            if (aNodeValue == null) {
                return false;
            }
            if (bNodeValue == null) {
                return false;
            }
            if (!aNodeValue.equals(bNodeValue)) {
                return false;
            }
        }
        if (!this.areAttributesSame(a, b)) {
            return false;
        }
        return this.checkChildren(a, b);
    }

    @Override
    public boolean getCommentsInsignificant() {
        return this.commentsInsignificant;
    }

    @Override
    public void setCommentsInsignificant(boolean ignoreComments) {
        this.commentsInsignificant = ignoreComments;
    }
}

