/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AttributeGroupModel
implements Loadable {
    private AttributeCollection children = null;
    private String name;
    private boolean loaded = false;

    AttributeGroupModel() {
    }

    boolean isLoaded() {
        return this.loaded;
    }

    private void loadAttributes(Element schemaElement, SchemaModelImpl model) throws SchemaException, InvalidSchemaException {
        this.children = new AttributeCollection();
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            String type = childElement.getLocalName();
            if (!type.equals("annotation")) {
                Object child;
                if (type.equals("attribute")) {
                    child = model.getAttributeModel(childElement);
                    this.children.add((AttributeModel)child);
                } else if (type.equals("attributeGroup")) {
                    child = model.getAttributeGroupModel(childElement);
                    this.children.add((AttributeGroupModel)child);
                } else {
                    throw new InvalidSchemaException("Invalid schema. Unexpected type: " + type);
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        if (schemaElement.hasAttribute("ref")) {
            throw new InternalErrorException("Internal error. Factory should have dereferenced the attributeGroup");
        }
        this.name = schemaElement.getAttribute("name");
        this.loadAttributes(schemaElement, model);
        this.loaded = true;
    }

    public void validateAndFix(Element docNode, DocumentFixer fixer) throws SchemaException {
        this.children.validateAndFix(docNode, fixer);
    }

    public boolean definesAttribute(String attributeName) {
        AttributeModel result = this.getAttributeModel(attributeName);
        return result != null;
    }

    public AttributeModel getAttributeModel(String attributeName) {
        return this.children.getAttributeModel(attributeName);
    }

    public AttributeModel getModel(Attr attr) throws SchemaException {
        return this.children.getModel(attr);
    }

    public String getName() {
        return this.name;
    }

    public Iterator<AttributeModel> attributeModels() {
        return this.children.attributeModels();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        buffer.append(this.getClass().getName());
        buffer.append(" name=");
        buffer.append(this.name);
        buffer.append('}');
        String result = buffer.toString();
        return result;
    }
}

