/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.Type;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeModelImpl
implements AttributeModel {
    private static final int USE_OPTIONAL = 1;
    private static final int USE_PROHIBITED = 2;
    private static final int USE_REQUIRED = 3;
    private int use;
    private SimpleType type;
    private String name;
    private String defaultValue = null;

    AttributeModelImpl() {
    }

    private void loadDefaultValue(final Element schemaElement) throws SchemaException, InvalidSchemaException {
        if (schemaElement.hasAttribute("default")) {
            this.defaultValue = schemaElement.getAttribute("default");
            this.type.assertIsValidValue(this.defaultValue, new MessageGenerator(){

                @Override
                public String getMessage() {
                    String errorPath = XPathGenerator.getXPath(schemaElement.getAttributeNode("default"));
                    String msg = "Invalid schema while loading attribute model " + AttributeModelImpl.this.name + " at location " + errorPath + ". Value of attribute default is not valid: " + AttributeModelImpl.this.defaultValue;
                    return msg;
                }
            });
        }
    }

    void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        if (schemaElement.hasAttribute("fixed")) {
            throw new SchemaException("Not implemented: attribute fixed");
        }
        if (schemaElement.hasAttribute("form")) {
            throw new SchemaException("Not implemented: attribute form");
        }
        if (schemaElement.hasAttribute("ref")) {
            throw new InternalErrorException("Internal Error. Factory should have dereferenced the attributeGroup");
        }
        if (!schemaElement.hasAttribute("name")) {
            throw new InvalidSchemaException("Schema error. name needed.");
        }
        this.name = schemaElement.getAttribute("name");
        this.use = 1;
        if (schemaElement.hasAttribute("use")) {
            String useValue = schemaElement.getAttribute("use");
            if (useValue.equals("optional")) {
                this.use = 1;
            } else if (useValue.equals("prohibited")) {
                this.use = 2;
            } else if (useValue.equals("required")) {
                this.use = 3;
            } else {
                throw new InvalidSchemaException("Schema error. Unexpected value for use: " + useValue);
            }
        }
        if (schemaElement.hasAttribute("type")) {
            String prefixedTypeName = schemaElement.getAttribute("type");
            NamespaceQualifiedName typeName = new NamespaceQualifiedName(prefixedTypeName, schemaElement);
            this.type = model.getNamedSimpleType(typeName);
        } else {
            Node schemaChild = schemaElement.getFirstChild();
            schemaChild = XmlUtils.skipBlankText(schemaChild);
            while (schemaChild != null) {
                Element childElement = (Element)schemaChild;
                String schemaType = childElement.getLocalName();
                if (!schemaType.equals("annotation")) {
                    if (schemaType.equals("simpleType")) {
                        if (this.type != null) {
                            throw new InvalidSchemaException("Invalid schema. Type defined more than once.");
                        }
                        this.type = model.getSimpleType(childElement);
                    } else {
                        throw new InvalidSchemaException("Invalid schema. Unexpected element: " + schemaType);
                    }
                }
                schemaChild = schemaChild.getNextSibling();
                schemaChild = XmlUtils.skipBlankText(schemaChild);
            }
        }
        if (this.type == null) {
            throw new InvalidSchemaException("Invalid schema. Type needed.");
        }
        this.loadDefaultValue(schemaElement);
    }

    private String getValidValue() throws SchemaException {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return this.type.getValidValue();
    }

    private void validateAndFixRequiredAttribute(Element element, DocumentFixer fixer) throws SchemaException {
        if (!element.hasAttribute(this.name)) {
            String validValue = this.getValidValue();
            fixer.createAttribute(element, this.name, validValue);
        } else {
            Attr attr = element.getAttributeNode(this.name);
            this.verifyType(attr, fixer);
        }
    }

    @Override
    public void validateAndFix(Element docNode, DocumentFixer fixer) throws SchemaException {
        switch (this.use) {
            case 1: {
                if (!docNode.hasAttribute(this.name)) break;
                Attr attr = docNode.getAttributeNode(this.name);
                this.verifyType(attr, fixer);
                break;
            }
            case 2: {
                if (!docNode.hasAttribute(this.name)) break;
                Attr attr = docNode.getAttributeNode(this.name);
                fixer.removeAttribute(attr);
                break;
            }
            case 3: {
                this.validateAndFixRequiredAttribute(docNode, fixer);
                break;
            }
            default: {
                throw new InternalErrorException("Internal error. Unexpected value in enumeration: " + this.use);
            }
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        boolean result = this.name.equals(attributeName);
        return result;
    }

    @Override
    public AttributeModel getAttributeModel(String attributeName) {
        if (!this.definesAttribute(attributeName)) {
            return null;
        }
        return this;
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.type.getSemanticValue(lexicalValue);
    }

    @Override
    public ContentModel getModel(Node childNode) throws SchemaException {
        if (!(childNode instanceof Attr)) {
            throw new InternalError("Child must be an attribute");
        }
        Attr child = (Attr)childNode;
        return this.getModel(child);
    }

    @Override
    public AttributeModel getModel(Attr attr) throws SchemaException {
        String attributeName = attr.getName();
        return this.getAttributeModel(attributeName);
    }

    @Override
    public ContentModel getModelForChildNode(Node docNode) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public Object getSemanticValue(Node node) throws SchemaException {
        Attr attr = (Attr)node;
        String lexicalValue = attr.getValue();
        Type type = this.getType();
        Object result = type.getSemanticValue(lexicalValue);
        return result;
    }

    private void verifyType(Attr attr, DocumentFixer fixer) throws SchemaException {
        String validValue;
        String attrValue = attr.getValue();
        if (attrValue != (validValue = this.type.verifyAndFix(attrValue))) {
            if (this.defaultValue != null) {
                validValue = this.defaultValue;
            }
            fixer.invalidValue(attr, validValue);
        }
    }
}

