/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import com.cognos.rspecupgrade.internal.xml.schema.Type;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ComplexContent
implements Type,
Cloneable {
    private ComplexTypeModel implementation;

    ComplexContent() {
    }

    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkAttributes(docElement, fixer);
    }

    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkChildren(docElement, fixer);
    }

    private ComplexTypeModel getExtensionBase(Element extensionElement, SchemaModelImpl schemaModel) throws SchemaException {
        String prefixedBaseName = extensionElement.getAttribute("base");
        NamespaceQualifiedName baseName = new NamespaceQualifiedName(prefixedBaseName, extensionElement);
        ComplexTypeModel base = schemaModel.loadComplexTypeModel(baseName, extensionElement.getOwnerDocument());
        return base;
    }

    private AttributeCollection collectExtensionAttributes(Element extensionElement, SchemaModelImpl schemaModel) throws SchemaException {
        AttributeCollection attributes = new AttributeCollection();
        Node childNode = extensionElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            Object attr;
            Element childElement = (Element)childNode;
            String typeName = childElement.getLocalName();
            if (typeName.equals("attribute")) {
                attr = schemaModel.getAttributeModel(childElement);
                attributes.add((AttributeModel)attr);
            } else if (typeName.equals("attributeGroup")) {
                attr = schemaModel.getAttributeGroupModel(childElement);
                attributes.add((AttributeGroupModel)attr);
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        return attributes;
    }

    private boolean isStructureElement(Element elem) {
        String typeName = elem.getLocalName();
        if (typeName.equals("all")) {
            return true;
        }
        if (typeName.equals("sequence")) {
            return true;
        }
        return typeName.equals("choice");
    }

    private Element findStructureExtensionElement(Element extensionElement) throws InvalidSchemaException {
        Node childNode = extensionElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            Element childElement = (Element)childNode;
            if (this.isStructureElement(childElement)) {
                return childElement;
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        return null;
    }

    private StructureModel findStructureExtension(Element extensionElement, SchemaModelImpl schemaModel) throws SchemaException {
        Element structureExtensionElement = this.findStructureExtensionElement(extensionElement);
        if (structureExtensionElement == null) {
            return null;
        }
        return schemaModel.getStructureModelNode(structureExtensionElement);
    }

    private Element findExtensionElement(Element complexContentElement) throws InvalidSchemaException {
        Element extensionElement = null;
        Node childNode = complexContentElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            Element childElement = (Element)childNode;
            String typeName = childElement.getLocalName();
            if (!typeName.equals("annotation") && typeName.equals("extension")) {
                if (extensionElement != null) {
                    throw new InvalidSchemaException("Schema error. More than one extension");
                }
                extensionElement = childElement;
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        if (extensionElement == null) {
            throw new InvalidSchemaException("Schema error. No extension defined");
        }
        return extensionElement;
    }

    private void loadExtension(Element schemaElement, SchemaModelImpl schemaModel) throws SchemaException {
        if (this.implementation != null) {
            throw new InvalidSchemaException("Schema error. More than one type");
        }
        String typeName = schemaElement.getLocalName();
        if (!typeName.equals("complexContent")) {
            throw new InternalErrorException("Internal error. Schema element should be complexContent not " + typeName + ".");
        }
        Element extensionElement = this.findExtensionElement(schemaElement);
        Node childNode = extensionElement.getFirstChild();
        childNode = XmlUtils.skipBlankTextAndComments(childNode);
        while (childNode != null) {
            String childTypeName;
            Element childElement = (Element)childNode;
            if (!(this.isStructureElement(childElement) || (childTypeName = childElement.getLocalName()).equals("annotation") || childTypeName.equals("attribute") || childTypeName.equals("attributeGroup"))) {
                String path = XPathGenerator.getXPath(childElement);
                throw new NotImplementedException("Not implemented. Extension child " + childTypeName + " " + path);
            }
            childNode = childNode.getNextSibling();
            childNode = XmlUtils.skipBlankTextAndComments(childNode);
        }
        ComplexTypeModel base = this.getExtensionBase(extensionElement, schemaModel);
        StructureModel extendedStructure = this.findStructureExtension(extensionElement, schemaModel);
        AttributeCollection extendedAttributes = this.collectExtensionAttributes(extensionElement, schemaModel);
        this.implementation = base.extend(extendedAttributes, extendedStructure);
    }

    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("complexContent")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                if (schemaType.equals("restriction")) {
                    if (this.implementation != null) {
                        throw new InvalidSchemaException("Schema error. More than one type");
                    }
                    throw new NotImplementedException("restiction");
                }
                if (schemaType.equals("extension")) {
                    this.loadExtension(schemaElement, model);
                } else {
                    throw new InvalidSchemaException("Schema error. Unexpected element: " + schemaType);
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.implementation.definesAttribute(attributeName);
    }

    public boolean definesElement(String elementName) throws SchemaException {
        return this.implementation.definesAttribute(elementName);
    }

    public ContentModel getModel(Node child) throws SchemaException {
        return this.implementation.getModel(child);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.implementation.getSemanticValue(lexicalValue);
    }

    public ComplexContent clone() throws CloneNotSupportedException {
        ComplexContent aClone = (ComplexContent)super.clone();
        aClone.implementation = this.implementation.clone();
        return aClone;
    }
}

