/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexContent;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ComplexTypeComplexContentImpl
implements ComplexTypeImplementation {
    private ComplexContent schemaChild;

    ComplexTypeComplexContentImpl() {
    }

    @Override
    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.schemaChild.checkAttributes(docElement, fixer);
    }

    @Override
    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.schemaChild.checkChildren(docElement, fixer);
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("complexType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        if (schemaElement.hasAttribute("abstract")) {
            throw new NotImplementedException("Not implemented. Attribute abstract");
        }
        if (schemaElement.hasAttribute("block")) {
            throw new NotImplementedException("Not implemented. Attribute block");
        }
        if (schemaElement.hasAttribute("final")) {
            throw new NotImplementedException("Not implemented. Attribute final");
        }
        if (schemaElement.hasAttribute("mixed")) {
            throw new NotImplementedException("Not implemented. Attribute mixed");
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                if (schemaType.equals("attribute") || schemaType.equals("attributeGroup")) {
                    throw new InvalidSchemaException("Invalid schema.  Complex types with complexContent may not have attributes.");
                }
                if (schemaType.equals("simpleContent")) {
                    throw new InternalErrorException("Internal error. Only complexType's with complexContent should be loaded with this class.");
                }
                if (schemaType.equals("complexContent")) {
                    if (this.schemaChild != null) {
                        throw new InvalidSchemaException("Invalid schema. Only one child permitted");
                    }
                    this.schemaChild = model.getComplexContent(childElement);
                } else {
                    throw new InternalErrorException("Internal error. Only complexType's with complexContent should be loaded with this class.");
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.schemaChild.definesAttribute(attributeName);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.schemaChild.definesElement(elementName);
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return this.schemaChild.getModel(child);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        throw new InvalidSchemaException("Complex Content does not have a semantic value");
    }

    @Override
    public void addAttribute(AttributeModel attr) throws InvalidSchemaException {
        throw new InvalidSchemaException("Invalid schema.  Complex types with complexContent may not have attributes.");
    }

    @Override
    public void addAttributeGroup(AttributeGroupModel attr) throws InvalidSchemaException {
        throw new InvalidSchemaException("Invalid schema.  Complex types with complexContent may not have attributes.");
    }

    @Override
    public ComplexTypeModel extend(AttributeCollection extendedAttributes, StructureModel extendedStructure) throws SchemaException {
        throw new NotImplementedException();
    }

    @Override
    public ComplexTypeComplexContentImpl clone() throws CloneNotSupportedException {
        ComplexTypeComplexContentImpl aClone = (ComplexTypeComplexContentImpl)super.clone();
        aClone.schemaChild = this.schemaChild.clone();
        return aClone;
    }
}

