/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeComplexContentImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeEmptyImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeSimpleContentImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeStructuredImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import com.cognos.rspecupgrade.internal.xml.schema.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexTypeModel
implements Type,
Loadable,
Cloneable {
    private ComplexTypeImplementation implementation;
    private boolean loaded = false;

    ComplexTypeModel() {
    }

    ComplexTypeModel(ComplexTypeImplementation theImplementation) {
        this.implementation = theImplementation;
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private void loadImplementation(Element complexTypeElement, SchemaModelImpl schemaModel) throws SchemaException {
        Node schemaChild = complexTypeElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            String schemaType = childElement.getLocalName();
            if (schemaType.equals("simpleContent")) {
                if (this.implementation != null) {
                    throw new InvalidSchemaException("Invalid schema. Too many children.Verify that schema is valid with XML Schema 1.1 Part 1: Structures, W3C Working Draft 31 August 2006 (http://www.w3.org/TR/xmlschema11-1/)");
                }
                this.implementation = new ComplexTypeSimpleContentImpl();
            } else if (schemaType.equals("complexContent")) {
                if (this.implementation != null) {
                    throw new InvalidSchemaException("Invalid schema. Too many children");
                }
                this.implementation = new ComplexTypeComplexContentImpl();
            } else if (schemaType.equals("all")) {
                this.implementation = new ComplexTypeStructuredImpl();
            } else if (schemaType.equals("group")) {
                this.implementation = new ComplexTypeStructuredImpl();
            } else if (schemaType.equals("sequence")) {
                this.implementation = new ComplexTypeStructuredImpl();
            } else if (schemaType.equals("choice")) {
                this.implementation = new ComplexTypeStructuredImpl();
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
        if (this.implementation == null) {
            this.implementation = new ComplexTypeEmptyImpl();
        }
        this.implementation.load(complexTypeElement, schemaModel);
    }

    @Override
    public void load(Element complexTypeElement, SchemaModelImpl schemaModel) throws SchemaException {
        if (this.isLoaded()) {
            return;
        }
        String schemaType = complexTypeElement.getLocalName();
        if (!schemaType.equals("complexType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        this.loadImplementation(complexTypeElement, schemaModel);
        this.loaded = true;
    }

    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkAttributes(docElement, fixer);
    }

    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkChildren(docElement, fixer);
    }

    public ContentModel getModel(Node child) throws SchemaException {
        return this.implementation.getModel(child);
    }

    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.implementation.definesAttribute(attributeName);
    }

    public boolean definesElement(String childName) throws SchemaException {
        return this.implementation.definesElement(childName);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.implementation.getSemanticValue(lexicalValue);
    }

    public void addAttribute(AttributeModel attr) throws SchemaException {
        this.implementation.addAttribute(attr);
    }

    public void addAttributeGroup(AttributeGroupModel attr) throws SchemaException {
        this.implementation.addAttributeGroup(attr);
    }

    public ComplexTypeModel extend(AttributeCollection extendedAttributes, StructureModel extendedStructure) throws SchemaException {
        return this.implementation.extend(extendedAttributes, extendedStructure);
    }

    public ComplexTypeModel clone() throws CloneNotSupportedException {
        ComplexTypeModel aClone = (ComplexTypeModel)super.clone();
        aClone.implementation = this.implementation.clone();
        return aClone;
    }
}

