/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ComplexTypeSimpleContentImpl
implements ComplexTypeImplementation {
    private AttributeCollection attributes = new AttributeCollection();
    private SimpleContentModel schemaChild;

    ComplexTypeSimpleContentImpl() {
    }

    @Override
    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.schemaChild.checkAttributes(docElement, fixer);
    }

    @Override
    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.schemaChild.checkChildren(docElement, fixer);
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("complexType")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        if (schemaElement.hasAttribute("abstract")) {
            throw new NotImplementedException("Not implemented.  Attribute abstract.");
        }
        if (schemaElement.hasAttribute("block")) {
            throw new NotImplementedException("Not implemented. Attribute block.");
        }
        if (schemaElement.hasAttribute("final")) {
            throw new NotImplementedException("Not implemented. Attribute final.");
        }
        if (schemaElement.hasAttribute("mixed")) {
            throw new NotImplementedException("Not implemented.  Attribute mixed.");
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                Object attr;
                if (schemaType.equals("attribute")) {
                    attr = model.getAttributeModel(childElement);
                    this.attributes.add((AttributeModel)attr);
                } else if (schemaType.equals("attributeGroup")) {
                    attr = model.getAttributeGroupModel(childElement);
                    this.attributes.add((AttributeGroupModel)attr);
                } else if (schemaType.equals("simpleContent")) {
                    if (this.schemaChild != null) {
                        throw new InvalidSchemaException("Invalid schema. Only one child permitted. Verify that schema is valid with XML Schema 1.1 Part 1: Structures, W3C Working Draft 31 August 2006 (http://www.w3.org/TR/xmlschema11-1/)");
                    }
                    this.schemaChild = model.getSimpleContent(childElement);
                } else {
                    if (schemaType.equals("complexContent")) {
                        throw new InternalErrorException("Internal error. Only complexTypes with simpleContent should be loaded with this class.");
                    }
                    throw new InternalErrorException("Internal error. only complexTypes with simpleContent should be loaded with this class.");
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) throws SchemaException {
        boolean result = this.attributes.definesAttribute(attributeName) || this.schemaChild.definesAttribute(attributeName);
        return result;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (child instanceof Attr) {
            return this.getModel((Attr)child);
        }
        return this.schemaChild.getModel(child);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.schemaChild.definesElement(elementName);
    }

    private AttributeModel getModel(Attr attr) throws SchemaException {
        AttributeModel result = this.attributes.getModel(attr);
        if (result != null) {
            return result;
        }
        return (AttributeModel)this.schemaChild.getModel(attr);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.schemaChild.getSemanticValue(lexicalValue);
    }

    @Override
    public void addAttribute(AttributeModel attr) {
        this.attributes.add(attr);
    }

    @Override
    public void addAttributeGroup(AttributeGroupModel attr) {
        this.attributes.add(attr);
    }

    @Override
    public ComplexTypeModel extend(AttributeCollection extendedAttributes, StructureModel extendedStructure) throws SchemaException {
        throw new NotImplementedException();
    }

    @Override
    public ComplexTypeSimpleContentImpl clone() throws CloneNotSupportedException {
        ComplexTypeSimpleContentImpl aClone = (ComplexTypeSimpleContentImpl)super.clone();
        aClone.attributes = this.attributes.clone();
        aClone.schemaChild = this.schemaChild;
        return aClone;
    }
}

