/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.TypeOperations;

public class DoubleOperations
implements TypeOperations<Double> {
    private static Double zero = new Double(0.0);

    private double getValue(Double obj) {
        return obj;
    }

    private static boolean isNegative(Double d) {
        return d.compareTo(zero) < 0;
    }

    private static boolean isNegativeInfinity(Double d) {
        if (!d.isInfinite()) {
            return false;
        }
        return DoubleOperations.isNegative(d);
    }

    private static boolean isPositiveInfinity(Double d) {
        if (!d.isInfinite()) {
            return false;
        }
        return d.compareTo(zero) == 1;
    }

    private long getSmallestNegativeNumber() {
        return -9223372036854775807L;
    }

    @Override
    public Double decrease(Double doubleObject) throws SchemaException {
        if (doubleObject.isNaN()) {
            return doubleObject;
        }
        if (DoubleOperations.isNegativeInfinity(doubleObject)) {
            return doubleObject;
        }
        double value = this.getValue(doubleObject);
        long bits = Double.doubleToLongBits(value);
        bits = bits == 0L ? this.getSmallestNegativeNumber() : (DoubleOperations.isNegative(doubleObject) ? ++bits : --bits);
        double smaller = Double.longBitsToDouble(bits);
        return new Double(smaller);
    }

    @Override
    public Double increase(Double doubleObject) throws SchemaException {
        if (doubleObject.isNaN()) {
            return doubleObject;
        }
        if (DoubleOperations.isPositiveInfinity(doubleObject)) {
            return doubleObject;
        }
        double value = this.getValue(doubleObject);
        long bits = Double.doubleToLongBits(value);
        bits = DoubleOperations.isNegative(doubleObject) ? --bits : ++bits;
        double larger = Double.longBitsToDouble(bits);
        return new Double(larger);
    }

    @Override
    public Double exclusiveBoundary(Double lowerBound, Double upperBound) throws SchemaException {
        double upper;
        double offset;
        double lower = this.getValue(lowerBound);
        double midPoint = lower + (offset = (upper = this.getValue(upperBound)) - lower) / 2.0;
        if (midPoint <= lower || midPoint >= upper) {
            throw new InvalidSchemaException("Failed to find a value between " + lower + " and " + upper + ".");
        }
        return new Double(midPoint);
    }

    @Override
    public Double newObject(String lexicalValue) throws SchemaException {
        try {
            return new Double(lexicalValue);
        }
        catch (Throwable t) {
            throw new SchemaException("Cannot create double from '" + lexicalValue + "'", t);
        }
    }

    @Override
    public String toString(Double object) {
        return object.toString();
    }
}

