/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeEmptyImpl;
import com.cognos.rspecupgrade.internal.xml.schema.ComplexTypeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.KeyModel;
import com.cognos.rspecupgrade.internal.xml.schema.KeyValues;
import com.cognos.rspecupgrade.internal.xml.schema.KeyrefModel;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.Type;
import com.cognos.rspecupgrade.internal.xml.schema.UniqueConstraint;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ElementModel
implements SingleModel,
Loadable,
ContentModel {
    String tagName;
    private SimpleType simpleTypeChild = null;
    private ComplexTypeModel complexTypeChild = null;
    private LinkedList<KeyModel> keys = new LinkedList();
    private LinkedList<KeyrefModel> keyrefs = new LinkedList();
    private LinkedList<UniqueConstraint> uniqueConstraints = new LinkedList();

    ElementModel() {
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        if (schemaElement.hasAttribute("abstract")) {
            throw new NotImplementedException("Not implemented.  Attribute abstract.");
        }
        if (schemaElement.hasAttribute("block")) {
            throw new NotImplementedException("Not implemented.  Attribute block.");
        }
        if (schemaElement.hasAttribute("default")) {
            throw new NotImplementedException("Not implemented.  Attribute default.");
        }
        if (schemaElement.hasAttribute("final")) {
            throw new NotImplementedException("Not implemented.  Attribute final.");
        }
        if (schemaElement.hasAttribute("fixed")) {
            throw new NotImplementedException("Not implemented.  Attribute fixed.");
        }
        if (schemaElement.hasAttribute("form")) {
            throw new NotImplementedException("Not implemented.  Attribute form.");
        }
        if (schemaElement.hasAttribute("nillable")) {
            throw new NotImplementedException("Not implemented.  Attribute nillable.");
        }
        if (schemaElement.hasAttribute("substitutionGroup")) {
            throw new NotImplementedException("Not implemented.  Attribute substitutionGroup");
        }
        if (schemaElement.hasAttribute("ref")) {
            throw new InternalErrorException("Internal error. Factory should have redirected the ref");
        }
        if (!schemaElement.hasAttribute("name")) {
            throw new InvalidSchemaException("Internal error.  Element has no name.");
        }
        this.tagName = schemaElement.getAttribute("name");
        if (schemaElement.hasAttribute("type")) {
            String prefixedTypeName = schemaElement.getAttribute("type");
            NamespaceQualifiedName typeName = new NamespaceQualifiedName(prefixedTypeName, schemaElement);
            if (model.hasNamedSimpleType(typeName)) {
                this.simpleTypeChild = model.getNamedSimpleType(typeName);
            }
            if (this.simpleTypeChild == null) {
                this.complexTypeChild = model.getNamedComplexType(typeName);
            }
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            String schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                if (schemaType.equals("key")) {
                    String keyName = childElement.getAttribute("name");
                    NamespaceQualifiedName qualifiedKeyName = new NamespaceQualifiedName(keyName, childElement);
                    KeyModel key = model.getNamedKey(qualifiedKeyName);
                    this.keys.addLast(key);
                } else if (schemaType.equals("unique")) {
                    UniqueConstraint constraint = new UniqueConstraint(childElement, model);
                    this.uniqueConstraints.addLast(constraint);
                } else if (schemaType.equals("keyref")) {
                    String keyrefName = childElement.getAttribute("name");
                    NamespaceQualifiedName qualifiedKeyrefName = new NamespaceQualifiedName(keyrefName, childElement);
                    KeyrefModel keyref = model.getNamedKeyref(qualifiedKeyrefName);
                    this.keyrefs.addLast(keyref);
                } else if (schemaType.equals("simpleType")) {
                    if (this.simpleTypeChild != null || this.complexTypeChild != null) {
                        throw new InvalidSchemaException("Invalid schema. Too many types");
                    }
                    this.simpleTypeChild = model.getSimpleType(childElement);
                } else if (schemaType.equals("complexType")) {
                    if (this.simpleTypeChild != null || this.complexTypeChild != null) {
                        throw new InvalidSchemaException("Invalid schema. Too many types");
                    }
                    this.complexTypeChild = model.getComplexTypeModelNode(childElement);
                } else {
                    throw new InvalidSchemaException("Invalid schema. Unexpected type " + schemaType);
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
        if (this.simpleTypeChild == null && this.complexTypeChild == null) {
            this.complexTypeChild = new ComplexTypeModel(new ComplexTypeEmptyImpl());
        }
    }

    @Override
    public LookaheadResult lookahead(Node docNode) throws SchemaException {
        if (!((docNode = XmlUtils.skipBlankTextAndComments(docNode)) instanceof Element)) {
            return LookaheadResult.No;
        }
        Element docElement = (Element)docNode;
        String docTag = docElement.getLocalName();
        if (docTag.equals(this.tagName)) {
            return LookaheadResult.Yes;
        }
        return LookaheadResult.No;
    }

    @Override
    public Node consume(Node docParent, Node docNode, DocumentFixer fixer) throws SchemaException {
        if (this.lookahead(docNode) != LookaheadResult.Yes) {
            throw new InternalErrorException("Internal error. Consuming when there is no match. Create should be called first to make the lookahead pass.");
        }
        docNode = XmlUtils.skipBlankTextAndComments(docNode);
        while (docNode != null && !(docNode instanceof Element)) {
            docNode = fixer.remove(docNode);
        }
        if (docNode == null) {
            docNode = this.create(docParent, docNode, fixer);
        }
        Node nextSibling = docNode.getNextSibling();
        Element docElement = (Element)docNode;
        String docTag = docElement.getLocalName();
        if (!docTag.equals(this.tagName)) {
            docNode = this.create(docParent, docNode, fixer);
            docElement = (Element)docNode;
        }
        if (this.simpleTypeChild != null) {
            Node docChild = docNode.getFirstChild();
            StringBuffer textBuffer = new StringBuffer();
            for (docChild = XmlUtils.skipBlankTextAndComments(docChild); docChild != null && docChild instanceof Text; docChild = docChild.getNextSibling()) {
                Text textNode = (Text)docChild;
                textBuffer.append(textNode.getData());
            }
            while (docChild != null) {
                docChild = fixer.remove(docChild);
            }
            String text = textBuffer.toString();
            String verifiedText = this.simpleTypeChild.verifyAndFix(text);
            if (verifiedText != text) {
                docChild = docNode.getFirstChild();
                while (docChild != null) {
                    docChild = fixer.remove(docChild);
                }
                fixer.createText(docNode, null, verifiedText);
            }
        } else {
            this.complexTypeChild.checkAttributes(docElement, fixer);
            this.complexTypeChild.checkChildren(docElement, fixer);
        }
        KeyValues keyValues = new KeyValues();
        for (KeyModel key : this.keys) {
            Set<Vector<Object>> values = key.getValues(docElement, fixer);
            keyValues.setKeyValues(key, values);
        }
        for (KeyrefModel keyref : this.keyrefs) {
            KeyModel key = keyref.getKey();
            Set<Vector<Object>> values = keyValues.getKeyValues(key);
            keyref.validate(docElement, values, fixer);
        }
        for (UniqueConstraint constraint : this.uniqueConstraints) {
            constraint.validate(docElement, fixer);
        }
        return nextSibling;
    }

    @Override
    public Node create(Node parent, Node nextSibling, DocumentFixer fixer) throws SchemaException {
        Element newElement = fixer.createElement(parent, nextSibling, this.tagName);
        return newElement;
    }

    @Override
    public int getMinOccurs() {
        return 1;
    }

    public boolean allowsChildElement(String childName) throws SchemaException {
        if (this.simpleTypeChild != null) {
            return false;
        }
        if (this.complexTypeChild != null) {
            return this.complexTypeChild.definesElement(childName);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append(this.getClass().getName());
        buffer.append(" tagName:");
        buffer.append(this.tagName);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public ContentModel getModel(Node node) throws SchemaException {
        if (!(node instanceof Element)) {
            return null;
        }
        Element elem = (Element)node;
        String nodeName = XmlUtils.getName(elem);
        if (!nodeName.equals(this.tagName)) {
            return null;
        }
        return this;
    }

    @Override
    public ContentModel getModelForChildNode(Node childNode) throws SchemaException {
        if (childNode instanceof Attr) {
            Attr child = (Attr)childNode;
            return this.getModelForChildNode(child);
        }
        if (childNode instanceof Element) {
            Element child = (Element)childNode;
            return this.getModelForChildNode(child);
        }
        throw new NotImplementedException("Child not supported: " + childNode.getClass().getName());
    }

    public String getTagName() {
        return this.tagName;
    }

    @Override
    public Type getType() {
        if (this.complexTypeChild != null) {
            return this.complexTypeChild;
        }
        return this.simpleTypeChild;
    }

    @Override
    public Object getSemanticValue(Node node) throws SchemaException {
        Element element = (Element)node;
        String lexicalValue = XmlUtils.getText(element);
        Type type = this.getType();
        Object result = type.getSemanticValue(lexicalValue);
        return result;
    }

    boolean defines(Element element) {
        String elemName = XmlUtils.getName(element);
        return elemName.equals(this.tagName);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return elementName.equals(this.tagName);
    }

    private AttributeModel getModelForChildNode(Attr child) throws SchemaException {
        if (this.complexTypeChild != null) {
            return (AttributeModel)this.complexTypeChild.getModel(child);
        }
        if (this.simpleTypeChild != null) {
            return (AttributeModel)this.complexTypeChild.getModel(child);
        }
        return null;
    }

    private ElementModel getModelForChildNode(Element childNode) throws SchemaException {
        Node parentNode = childNode.getParentNode();
        if (!(parentNode instanceof Element)) {
            throw new InternalErrorException("childNode's parent must be an element");
        }
        Element parentElem = (Element)parentNode;
        String parentName = XmlUtils.getName(parentElem);
        if (!parentName.equals(this.tagName)) {
            throw new InternalErrorException("Parent of childNode is not for this model.");
        }
        if (this.simpleTypeChild != null) {
            return (ElementModel)this.simpleTypeChild.getModel(childNode);
        }
        if (this.complexTypeChild != null) {
            return (ElementModel)this.complexTypeChild.getModel(childNode);
        }
        return null;
    }
}

