/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.selector.ParseException;
import com.cognos.rspecupgrade.internal.xml.schema.selector.SelectorPath;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Selector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Field {
    private Selector xpath;
    private SchemaModelImpl schemaModel;

    Field(Element schemaElement, SchemaModelImpl schemaModel) throws SchemaException {
        this.schemaModel = schemaModel;
        try {
            String path = schemaElement.getAttribute("xpath");
            this.xpath = SelectorPath.compile(path, schemaElement);
        }
        catch (ParseException e) {
            throw new InvalidSchemaException(e);
        }
    }

    boolean isDefined(Element base) throws SchemaException {
        Node node = this.evaluateXpath(base);
        return node != null;
    }

    ContentModel getDefiningModel(Node node) throws SchemaException, InternalErrorException {
        ContentModel model;
        if (node instanceof Attr) {
            model = this.schemaModel.getDefiningModel((Attr)node);
        } else if (node instanceof Element) {
            model = this.schemaModel.getDefiningModel((Element)node);
        } else {
            throw new InternalErrorException("only elements and attributes should have been selected");
        }
        return model;
    }

    Object getSemanticValue(Element base) throws SchemaException {
        Node node = this.evaluateXpath(base);
        if (node == null) {
            return null;
        }
        ContentModel model = this.getDefiningModel(node);
        Object result = model.getSemanticValue(node);
        return result;
    }

    private Node evaluateXpath(Element base) throws SchemaException {
        NodeList nodes = this.xpath.evaluate(base);
        int nbNodes = nodes.getLength();
        if (nbNodes == 0) {
            return null;
        }
        if (nbNodes == 1) {
            return nodes.item(0);
        }
        throw new InvalidSchemaException("More than one node is returned from fields xpath");
    }
}

