/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class GroupModel
implements SingleModel,
Loadable {
    private StructureModel child = null;

    GroupModel() {
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        if (schemaElement.hasAttribute("ref")) {
            throw new InternalErrorException("Internal error. Factory should have replaced ref.");
        }
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            StructureModel modelNode = model.getStructureModelNode(childElement);
            if (modelNode != null && this.child != null) {
                throw new InvalidSchemaException("Invalid schema. Two children in group");
            }
            this.child = modelNode;
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public LookaheadResult lookahead(Node docNode) throws SchemaException {
        if (this.child == null) {
            return LookaheadResult.NoTokensConsumed;
        }
        return this.child.lookahead(docNode);
    }

    @Override
    public Node consume(Node parentNode, Node docNode, DocumentFixer fixer) throws SchemaException {
        if (this.lookahead(docNode) != LookaheadResult.Yes) {
            throw new InternalErrorException("Internal error. Consuming when there is no match. Create should be called first to make the lookahead pass.");
        }
        if (this.child == null) {
            return docNode;
        }
        return this.child.consume(parentNode, docNode, fixer);
    }

    @Override
    public Node create(Node parentNode, Node nextSibling, DocumentFixer fixer) throws SchemaException {
        if (this.child == null) {
            throw new InternalErrorException("Internal error. Group is empty.");
        }
        return this.child.consume(parentNode, nextSibling, fixer);
    }

    @Override
    public int getMinOccurs() {
        return 1;
    }

    @Override
    public ContentModel getModel(Node childElement) throws SchemaException {
        if (childElement instanceof Attr) {
            throw new InternalErrorException("Groups do not define attributes");
        }
        return this.child.getModel(childElement);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.child.definesElement(elementName);
    }
}

