/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.RangeFramework;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.TypeOperations;
import java.math.BigInteger;

public class IntegralRange
extends RangeFramework<BigInteger> {
    private static BigInteger bigONE = new BigInteger("1");
    private static BigInteger bigTWO = new BigInteger("2");
    private static BigInteger bigMINUSONE = new BigInteger("-1");

    public IntegralRange() {
        super(new BigIntegerOperations());
    }

    protected IntegralRange(BigInteger initialMinimum, BigInteger initialMaximum) {
        super(new BigIntegerOperations(), initialMinimum, initialMaximum);
    }

    public IntegralRange(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        super(new BigIntegerOperations(), minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    public static class BigIntegerOperations
    implements TypeOperations<BigInteger> {
        @Override
        public BigInteger decrease(BigInteger obj) throws SchemaException {
            return obj.add(bigMINUSONE);
        }

        @Override
        public BigInteger increase(BigInteger obj) throws SchemaException {
            return obj.add(bigONE);
        }

        @Override
        public BigInteger exclusiveBoundary(BigInteger lower, BigInteger upper) throws SchemaException {
            BigInteger offset = upper.subtract(lower);
            BigInteger halfOffset = offset.add(bigONE).divide(bigTWO);
            BigInteger midPoint = lower.add(halfOffset);
            if (midPoint.compareTo(upper) >= 0) {
                throw new InvalidSchemaException("Failed to find a value between " + lower.toString() + " and " + upper.toString() + ".");
            }
            return midPoint;
        }

        @Override
        public BigInteger newObject(String lexicalValue) throws SchemaException {
            try {
                return new BigInteger(lexicalValue);
            }
            catch (NumberFormatException e) {
                throw new SchemaException(e);
            }
        }

        @Override
        public String toString(BigInteger object) {
            return object.toString();
        }
    }
}

