/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.Field;
import com.cognos.rspecupgrade.internal.xml.schema.Fields;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.KeyModel;
import com.cognos.rspecupgrade.internal.xml.schema.Loadable;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.selector.ParseException;
import com.cognos.rspecupgrade.internal.xml.schema.selector.SelectorPath;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Selector;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class KeyrefModel
implements Loadable {
    private String name;
    private KeyModel keyModel;
    private Selector selectorPath;
    private Fields fields = new Fields();

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        try {
            this.name = schemaElement.getAttribute("name");
            String refer = schemaElement.getAttribute("refer");
            NamespaceQualifiedName qualifiedRefer = new NamespaceQualifiedName(refer, schemaElement);
            this.keyModel = model.getNamedKey(qualifiedRefer);
            Element selectorElem = XmlUtils.getFirstChildElementByName(schemaElement, "selector");
            if (selectorElem == null) {
                throw new InvalidSchemaException("selector element missing from keyref");
            }
            String selectorXpath = selectorElem.getAttribute("xpath");
            this.selectorPath = SelectorPath.compile(selectorXpath, selectorElem);
            NodeList fieldList = XmlUtils.getChildElementsByName(schemaElement, "field");
            int nbFields = fieldList.getLength();
            for (int i = 0; i < nbFields; ++i) {
                Element fieldElem = (Element)fieldList.item(i);
                Field field = new Field(fieldElem, model);
                this.fields.add(field);
            }
        }
        catch (ParseException e) {
            throw new InvalidSchemaException(e.getLocalizedMessage());
        }
    }

    String getName() {
        return this.name;
    }

    KeyModel getKey() {
        return this.keyModel;
    }

    public void validate(Element docElement, Set<Vector<Object>> values, DocumentFixer fixer) throws SchemaException {
        NodeList qualifiedSet = this.selectorPath.evaluate(docElement);
        int nbElements = qualifiedSet.getLength();
        for (int elementNb = 0; elementNb < nbElements; ++elementNb) {
            Vector<Object> keySequence;
            Element keyrefMember = (Element)qualifiedSet.item(elementNb);
            if (!this.isDefined(keyrefMember) || values.contains(keySequence = this.fields.getSemanticValue(keyrefMember))) continue;
            fixer.keyrefMissing(docElement, this.name, keySequence);
        }
    }

    private boolean isDefined(Element elem) throws SchemaException {
        return this.fields.isDefined(elem);
    }
}

