/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.RangeFramework;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.TypeOperations;

public class LongRange
extends RangeFramework<Long> {
    public LongRange() throws SchemaException {
        super(new LongOperations(), null, Long.toString(Long.MIN_VALUE), Long.toString(Long.MAX_VALUE), null);
    }

    public LongRange(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        super(new LongOperations());
        this.setMinInclusive(Long.toString(Long.MIN_VALUE));
        this.setMaxInclusive(Long.toString(Long.MAX_VALUE));
        this.setMinExclusive(minExclusive);
        this.setMinInclusive(minInclusive);
        this.setMaxInclusive(maxInclusive);
        this.setMaxExclusive(maxExclusive);
    }

    public static class LongOperations
    implements TypeOperations<Long> {
        private long getValue(Long obj) {
            return obj;
        }

        @Override
        public Long decrease(Long obj) throws SchemaException {
            long bigger = this.getValue(obj);
            long smaller = bigger - 1L;
            if (smaller >= bigger) {
                throw new InvalidSchemaException("Numeric overflow: Out of range for long.");
            }
            return new Long(smaller);
        }

        @Override
        public Long increase(Long obj) throws SchemaException {
            long bigger;
            long smaller = this.getValue(obj);
            if (smaller >= (bigger = smaller + 1L)) {
                throw new InvalidSchemaException("Numeric overflow: Out of range for long.");
            }
            return new Long(bigger);
        }

        @Override
        public Long exclusiveBoundary(Long lowerBound, Long upperBound) throws SchemaException {
            long upper;
            long offset;
            long halfOffset;
            long lower = this.getValue(lowerBound);
            long midPoint = lower + (halfOffset = ((offset = (upper = this.getValue(upperBound)) - lower) + 1L) / 2L);
            if (midPoint <= lower || midPoint >= upper) {
                throw new InvalidSchemaException("Failed to find a value between " + lower + " and " + upper + ".");
            }
            return new Long(midPoint);
        }

        @Override
        public Long newObject(String lexicalValue) throws SchemaException {
            if ((lexicalValue = lexicalValue.trim()).startsWith("+")) {
                lexicalValue = lexicalValue.substring(1);
            }
            try {
                return new Long(lexicalValue);
            }
            catch (NumberFormatException e) {
                throw new SchemaException(e);
            }
        }

        @Override
        public String toString(Long object) {
            return object.toString();
        }
    }
}

