/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.LookaheadResult;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SingleModel;
import com.cognos.rspecupgrade.internal.xml.schema.StructureModel;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class MultipleModel
implements StructureModel {
    private int minOccurs;
    private int maxOccurs;
    private SingleModel repeatedNode;

    public MultipleModel(int minOccurs, int maxOccurs, SingleModel repeatedNode) throws SchemaException {
        if (minOccurs < 0) {
            throw new InvalidSchemaException("Invalid schema. minOccurs may not be negative.");
        }
        if (maxOccurs < minOccurs) {
            throw new InvalidSchemaException("Invalid schema. maxOccurs must not be less than minOccurs");
        }
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.repeatedNode = repeatedNode;
    }

    @Override
    public LookaheadResult lookahead(Node docNode) throws SchemaException {
        LookaheadResult result = this.repeatedNode.lookahead(docNode = XmlUtils.skipBlankTextAndComments(docNode));
        if (result == LookaheadResult.No && this.minOccurs < 1) {
            result = LookaheadResult.NoTokensConsumed;
        }
        return result;
    }

    @Override
    public Node consume(Node parentNode, Node docNode, DocumentFixer fixer) throws SchemaException {
        LookaheadResult lookaheadResult;
        if (this.lookahead(docNode) != LookaheadResult.Yes) {
            throw new InternalErrorException("Internal error. Consuming when there is no match. Create should be called first to make the lookahead pass.");
        }
        int occurs = 0;
        Node sibling = XmlUtils.skipBlankTextAndComments(docNode);
        while (occurs < this.minOccurs) {
            lookaheadResult = this.repeatedNode.lookahead(sibling = XmlUtils.skipBlankTextAndComments(sibling));
            if (lookaheadResult == LookaheadResult.No) {
                sibling = this.repeatedNode.create(parentNode, sibling, fixer);
                continue;
            }
            if (lookaheadResult == LookaheadResult.NoTokensConsumed) {
                occurs = this.minOccurs;
                continue;
            }
            sibling = this.repeatedNode.consume(parentNode, sibling, fixer);
            sibling = XmlUtils.skipBlankTextAndComments(sibling);
            ++occurs;
        }
        sibling = XmlUtils.skipBlankTextAndComments(sibling);
        while (sibling != null && occurs < this.maxOccurs) {
            lookaheadResult = this.repeatedNode.lookahead(sibling);
            if (lookaheadResult == LookaheadResult.Yes) {
                sibling = this.repeatedNode.consume(parentNode, sibling, fixer);
                sibling = XmlUtils.skipBlankTextAndComments(sibling);
                ++occurs;
                continue;
            }
            if (lookaheadResult != LookaheadResult.NoTokensConsumed) break;
            occurs = this.maxOccurs;
        }
        sibling = XmlUtils.skipBlankTextAndComments(sibling);
        while (this.repeatedNode.lookahead(sibling) == LookaheadResult.Yes) {
            if (!(sibling instanceof Element)) {
                throw new InternalErrorException("Internal error. Lookahead should have failed since text nodes can not be repeated.");
            }
            sibling = fixer.remove(sibling);
            sibling = XmlUtils.skipBlankTextAndComments(sibling);
        }
        return sibling;
    }

    @Override
    public Node create(Node parentNode, Node nextSibling, DocumentFixer fixer) throws SchemaException {
        if (this.minOccurs < 1) {
            throw new InternalErrorException("Internal error. No need to create since minOccurs is less than 1.");
        }
        return this.repeatedNode.create(parentNode, nextSibling, fixer);
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (child instanceof Attr) {
            throw new InternalErrorException("Multiple models  cannot be used for attributes.");
        }
        return this.repeatedNode.getModel(child);
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.repeatedNode.definesElement(elementName);
    }
}

