/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import org.w3c.dom.Node;

class NamespaceQualifiedName {
    private String namespaceUri;
    private String name;

    public NamespaceQualifiedName(String namespaceUri, String name) {
        if (namespaceUri == null) {
            namespaceUri = "";
        }
        this.namespaceUri = namespaceUri;
        this.name = name;
    }

    NamespaceQualifiedName(String prefixedName, Node context) {
        int colonPos = prefixedName.indexOf(":");
        String prefix = colonPos < 0 ? "" : prefixedName.substring(0, colonPos);
        this.namespaceUri = XmlUtils.getNameSpaceUriForPrefix(prefix, context);
        if (this.namespaceUri == null) {
            this.namespaceUri = "";
        }
        this.name = prefixedName.substring(colonPos + 1);
    }

    public NamespaceQualifiedName(Node node) {
        this.namespaceUri = node.getNamespaceURI();
        if (this.namespaceUri == null) {
            this.namespaceUri = "";
        }
        this.name = node.getLocalName();
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.namespaceUri == null ? 0 : this.namespaceUri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamespaceQualifiedName other = (NamespaceQualifiedName)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.namespaceUri == null ? other.namespaceUri != null : !this.namespaceUri.equals(other.namespaceUri));
    }

    public String toString() {
        return "(" + this.namespaceUri + " " + this.name + ")";
    }
}

