/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.TypeOperations;

public class RangeFramework<SemanticType extends Comparable<SemanticType>>
implements Range {
    private TypeOperations<SemanticType> operations;
    private SemanticType minExclusive = null;
    private SemanticType minInclusive = null;
    private SemanticType maxInclusive = null;
    private SemanticType maxExclusive = null;

    private SemanticType minimum(SemanticType a, SemanticType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.compareTo(b) <= 0) {
            return a;
        }
        return b;
    }

    private SemanticType maximum(SemanticType a, SemanticType b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }

    private void minExlusiveInvariants() throws SchemaException {
        if (this.minExclusive == null) {
            return;
        }
        if (this.minInclusive != null) {
            throw new InternalErrorException("Only one of minExclusive or minInclusive should be set");
        }
        if (this.maxExclusive != null && this.minExclusive.compareTo(this.maxExclusive) >= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
        if (this.maxInclusive != null && this.minExclusive.compareTo(this.maxInclusive) >= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
    }

    private void minInclusiveInvariants() throws SchemaException {
        if (this.minInclusive == null) {
            return;
        }
        if (this.minExclusive != null) {
            throw new InternalErrorException("Only one of minExclusive or minInclusive should be set");
        }
        if (this.maxExclusive != null && this.minInclusive.compareTo(this.maxExclusive) >= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
        if (this.maxInclusive != null && this.minInclusive.compareTo(this.maxInclusive) > 0) {
            throw new InvalidSchemaException("Schema error.");
        }
    }

    private void maxInclusiveInvariants() throws SchemaException {
        if (this.maxInclusive == null) {
            return;
        }
        if (this.maxExclusive != null) {
            throw new InternalErrorException("Only one of maxExclusive or maxInclusive should be set");
        }
        if (this.minExclusive != null && this.maxInclusive.compareTo(this.minExclusive) <= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
        if (this.minInclusive != null && this.maxInclusive.compareTo(this.minInclusive) < 0) {
            throw new InvalidSchemaException("Schema error.");
        }
    }

    private void maxExlusiveInvariants() throws SchemaException {
        if (this.maxExclusive == null) {
            return;
        }
        if (this.maxInclusive != null) {
            throw new InternalErrorException("Only one of maxExclusive or mxInclusive should be set");
        }
        if (this.minExclusive != null && this.maxExclusive.compareTo(this.minExclusive) <= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
        if (this.minInclusive != null && this.maxExclusive.compareTo(this.minInclusive) <= 0) {
            throw new InvalidSchemaException("Schema error.");
        }
    }

    void classInvariants() throws SchemaException {
        this.minExlusiveInvariants();
        this.minInclusiveInvariants();
        this.maxInclusiveInvariants();
        this.maxExlusiveInvariants();
    }

    protected RangeFramework(TypeOperations<SemanticType> operations) {
        this.operations = operations;
    }

    protected RangeFramework(TypeOperations<SemanticType> operations, SemanticType initialMinimumInclusive, SemanticType initialMaximumInclusive) {
        this.operations = operations;
        this.minInclusive = initialMinimumInclusive;
        this.maxInclusive = initialMaximumInclusive;
    }

    protected RangeFramework(TypeOperations<SemanticType> operations, String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        this.operations = operations;
        this.setMinExclusive(minExclusive);
        this.setMinInclusive(minInclusive);
        this.setMaxInclusive(maxInclusive);
        this.setMaxExclusive(maxExclusive);
    }

    @Override
    public Range newRangeInstance(String lexicalMinExclusive, String lexicalMinInclusive, String lexicalMaxInclusive, String lexicalMaxExclusive) throws SchemaException {
        RangeFramework<SemanticType> result = new RangeFramework<SemanticType>(this.operations);
        result.minExclusive = this.minExclusive;
        result.minInclusive = this.minInclusive;
        result.maxInclusive = this.maxInclusive;
        result.maxExclusive = this.maxExclusive;
        result.setMinExclusive(lexicalMinExclusive);
        result.setMinInclusive(lexicalMinInclusive);
        result.setMaxInclusive(lexicalMaxInclusive);
        result.setMaxExclusive(lexicalMaxExclusive);
        return result;
    }

    private String calcCommonDefaultValue() {
        if (this.isValidValue("0")) {
            return "0";
        }
        if (this.isValidValue("1")) {
            return "1";
        }
        if (this.isValidValue("-1")) {
            return "-1";
        }
        return null;
    }

    private String calcInclusiveBoundaryDefaultValue() {
        if (this.minInclusive != null) {
            return this.minInclusive.toString();
        }
        if (this.maxInclusive != null) {
            return this.maxInclusive.toString();
        }
        return null;
    }

    private String calcExclusiveBoundaryDefaultValue() throws SchemaException {
        if (this.minInclusive != null || this.maxInclusive != null) {
            throw new InternalErrorException("should have only exclusive boundaries set.");
        }
        if (this.minExclusive != null && this.maxExclusive == null) {
            return this.operations.toString(this.operations.increase(this.minExclusive));
        }
        if (this.minExclusive == null && this.maxExclusive != null) {
            return this.operations.toString(this.operations.decrease(this.maxExclusive));
        }
        SemanticType validSemanticValue = this.operations.exclusiveBoundary(this.minExclusive, this.maxExclusive);
        return this.operations.toString(validSemanticValue);
    }

    private String calcValidValue() throws SchemaException {
        String result = this.calcCommonDefaultValue();
        if (result != null) {
            return result;
        }
        result = this.calcInclusiveBoundaryDefaultValue();
        if (result != null) {
            return result;
        }
        result = this.calcExclusiveBoundaryDefaultValue();
        if (result != null) {
            return result;
        }
        throw new InvalidSchemaException("Failed to calculate a valid value for this range.");
    }

    @Override
    public String getValidValue() throws SchemaException {
        String validValue = this.calcValidValue();
        if (!this.isValidValue(validValue)) {
            throw new SchemaException("Unable to find a valid value in the range");
        }
        return validValue;
    }

    private SemanticType getSemanticValue(String lexicalValue) throws SchemaException {
        SemanticType semanticValue = this.operations.newObject(lexicalValue);
        return semanticValue;
    }

    private SemanticType getValidLowSemanticValue() throws SchemaException {
        SemanticType semanticValue;
        if (this.minInclusive != null) {
            return this.minInclusive;
        }
        if (this.minExclusive != null && this.isValidSemanticValue(semanticValue = this.operations.increase(this.minExclusive))) {
            return semanticValue;
        }
        return null;
    }

    private SemanticType getValidHighSemanticValue() throws SchemaException {
        SemanticType semanticValue;
        if (this.maxInclusive != null) {
            return this.maxInclusive;
        }
        if (this.maxExclusive != null && this.isValidSemanticValue(semanticValue = this.operations.decrease(this.maxExclusive))) {
            return semanticValue;
        }
        return null;
    }

    @Override
    public String getValidValue(String invalidValue) throws SchemaException {
        if (invalidValue == null) {
            return this.getValidValue();
        }
        SemanticType semanticValue = null;
        try {
            semanticValue = this.getSemanticValue(invalidValue);
        }
        catch (SchemaException e) {
            return this.getValidValue();
        }
        Object newSemanticValue = null;
        if (this.isSemanticValueTooLow(semanticValue)) {
            newSemanticValue = this.getValidLowSemanticValue();
        }
        if (this.isSemanticValueTooHigh(semanticValue)) {
            newSemanticValue = this.getValidHighSemanticValue();
        }
        if (newSemanticValue != null) {
            return newSemanticValue.toString();
        }
        return this.getValidValue();
    }

    private boolean isSemanticValueTooHigh(SemanticType semanticValue) {
        if (this.maxInclusive != null && semanticValue.compareTo(this.maxInclusive) > 0) {
            return true;
        }
        return this.maxExclusive != null && semanticValue.compareTo(this.maxExclusive) >= 0;
    }

    private boolean isSemanticValueTooLow(SemanticType semanticValue) {
        if (this.minInclusive != null && semanticValue.compareTo(this.minInclusive) < 0) {
            return true;
        }
        return this.minExclusive != null && semanticValue.compareTo(this.minExclusive) <= 0;
    }

    protected boolean isValidSemanticValue(SemanticType semanticValue) {
        if (this.isSemanticValueTooHigh(semanticValue)) {
            return false;
        }
        return !this.isSemanticValueTooLow(semanticValue);
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        SemanticType semanticValue = null;
        try {
            semanticValue = this.getSemanticValue(lexicalValue);
        }
        catch (SchemaException e) {
            return false;
        }
        return this.isValidSemanticValue(semanticValue);
    }

    @Override
    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        SemanticType semanticValue = null;
        try {
            semanticValue = this.getSemanticValue(lexicalValue);
        }
        catch (SchemaException e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Unable to convert to lexical value: ");
            buffer.append(lexicalValue);
            buffer.append("\n");
            buffer.append(message.getMessage());
            throw new InvalidSchemaException(buffer.toString(), e);
        }
        if (!this.isValidSemanticValue(semanticValue)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Value is not in range. Value=");
            buffer.append(semanticValue);
            buffer.append(" minExclusive=");
            buffer.append(this.minExclusive);
            buffer.append(" minInclusive=");
            buffer.append(this.minInclusive);
            buffer.append(" maxInclusive=");
            buffer.append(this.maxInclusive);
            buffer.append(" maxExclusive=");
            buffer.append(this.maxExclusive);
            buffer.append("\n");
            buffer.append(message.getMessage());
            throw new InvalidSchemaException(buffer.toString());
        }
    }

    public String validateAndFix(String lexicalValue) throws SchemaException {
        if (this.isValidValue(lexicalValue)) {
            return lexicalValue;
        }
        return this.getValidValue(lexicalValue);
    }

    private void normalizeMinimumBoundaries() {
        if (this.minExclusive != null && this.minInclusive != null) {
            if (this.minExclusive.compareTo(this.minInclusive) >= 0) {
                this.minInclusive = null;
            } else {
                this.minExclusive = null;
            }
        }
    }

    private void normalizeMaximumBoundaries() {
        if (this.maxExclusive != null && this.maxInclusive != null) {
            if (this.maxExclusive.compareTo(this.maxInclusive) <= 0) {
                this.maxInclusive = null;
            } else {
                this.maxExclusive = null;
            }
        }
    }

    protected void setMaxExclusive(String max) throws SchemaException {
        if (max == null) {
            return;
        }
        SemanticType newValue = this.operations.newObject(max);
        if (!this.isValidSemanticValue(newValue)) {
            throw new InvalidSchemaException("Maximum exclusive value is not valid: " + max);
        }
        this.maxExclusive = this.minimum(this.maxExclusive, newValue);
        this.normalizeMaximumBoundaries();
        this.classInvariants();
    }

    protected void setMaxInclusive(String max) throws SchemaException {
        if (max == null) {
            return;
        }
        SemanticType newValue = this.operations.newObject(max);
        if (!this.isValidSemanticValue(newValue)) {
            throw new InvalidSchemaException("Maximum inclusive value is not valid: " + max);
        }
        this.maxInclusive = this.minimum(this.maxInclusive, newValue);
        this.normalizeMaximumBoundaries();
        this.classInvariants();
    }

    protected void setMinExclusive(String min) throws SchemaException {
        if (min == null) {
            return;
        }
        SemanticType newValue = this.operations.newObject(min);
        if (!this.isValidSemanticValue(newValue)) {
            throw new InvalidSchemaException("Minimum exclusive value is not valid: " + min);
        }
        this.minExclusive = this.maximum(newValue, this.minExclusive);
        this.normalizeMinimumBoundaries();
        this.classInvariants();
    }

    protected void setMinInclusive(String min) throws SchemaException {
        if (min == null) {
            return;
        }
        SemanticType newValue = this.operations.newObject(min);
        if (!this.isValidSemanticValue(newValue)) {
            throw new InvalidSchemaException("Minimum inclusive value is not valid: " + min);
        }
        this.minInclusive = this.maximum(newValue, this.minInclusive);
        this.normalizeMinimumBoundaries();
        this.classInvariants();
    }
}

