/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.Restriction;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

class RestrictionEnumeration
implements Restriction {
    private SimpleType baseType;
    private Set<Object> enumeratedValues = new HashSet<Object>();
    private String validValue;

    RestrictionEnumeration(SimpleType base) {
        this.baseType = base;
    }

    private Object getSemanticValue(String lexicalValue) throws InternalErrorException {
        Object semanticValue;
        try {
            semanticValue = this.baseType.getSemanticValue(lexicalValue);
        }
        catch (SchemaException e) {
            throw new InternalErrorException("Valid value failed to get semantic value\nlexical value is " + lexicalValue + "\n" + "base type is:" + this.baseType.getName().toString());
        }
        return semanticValue;
    }

    void addEnumeratedValue(final String lexicalValue, final MessageGenerator errorMessage) throws InvalidSchemaException, InternalErrorException {
        if (this.validValue == null) {
            this.validValue = lexicalValue;
        }
        this.baseType.assertIsValidValue(lexicalValue, new MessageGenerator(){

            @Override
            public String getMessage() {
                StringBuffer buffer = new StringBuffer("Enumeration value is not valid against base type\n");
                buffer.append("lexical value is ");
                buffer.append(lexicalValue);
                buffer.append("\n");
                buffer.append("base type is:");
                buffer.append(RestrictionEnumeration.this.baseType.getName().toString());
                buffer.append("\n");
                buffer.append(errorMessage.getMessage());
                return buffer.toString();
            }
        });
        Object semanticValue = this.getSemanticValue(lexicalValue);
        this.enumeratedValues.add(semanticValue);
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        Object semanticValue;
        try {
            semanticValue = this.baseType.getSemanticValue(lexicalValue);
        }
        catch (SchemaException e) {
            return false;
        }
        for (Object validValue : this.enumeratedValues) {
            if (!validValue.equals(semanticValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getValidValue(String hint) throws SchemaException {
        return this.validValue;
    }

    @Override
    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(lexicalValue)) {
            StringBuffer messageBuffer = new StringBuffer();
            messageBuffer.append("lexicalValue (");
            messageBuffer.append(lexicalValue);
            messageBuffer.append(") did not match an enumerated value (");
            Iterator<Object> iter = this.enumeratedValues.iterator();
            while (iter.hasNext()) {
                messageBuffer.append(iter.next());
                messageBuffer.append(" ");
            }
            messageBuffer.append(" )\n");
            messageBuffer.append(message.getMessage());
            throw new InvalidSchemaException(messageBuffer.toString());
        }
    }
}

