/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.Restriction;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class RestrictionPattern
implements Restriction {
    private Pattern restrictionPattern;

    public RestrictionPattern(String pattern) throws InvalidSchemaException {
        try {
            this.restrictionPattern = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidSchemaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValidValue(String lexicalValue) {
        if (this.restrictionPattern != null) {
            RestrictionPattern restrictionPattern = this;
            synchronized (restrictionPattern) {
                Matcher matcher = this.restrictionPattern.matcher(lexicalValue);
                if (!matcher.matches()) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(lexicalValue)) {
            StringBuffer messageBuffer = new StringBuffer();
            messageBuffer.append("lexicalValue (");
            messageBuffer.append(lexicalValue);
            messageBuffer.append(") did not match pattern (");
            messageBuffer.append(this.restrictionPattern.pattern());
            messageBuffer.append(")\n");
            messageBuffer.append(message.getMessage());
            throw new InvalidSchemaException(messageBuffer.toString());
        }
    }

    @Override
    public String getValidValue(String hint) throws SchemaException {
        return null;
    }
}

