/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeCollection;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeGroupModel;
import com.cognos.rspecupgrade.internal.xml.schema.AttributeModel;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class SimpleContentExtensionImpl
implements SimpleContentImplementation {
    private SimpleType base = null;
    private AttributeCollection attributes = new AttributeCollection();

    SimpleContentExtensionImpl() throws SchemaException {
    }

    @Override
    public void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        String schemaType = schemaElement.getLocalName();
        if (!schemaType.equals("simpleContent")) {
            throw new InternalErrorException("Internal error. Unexpected type: " + schemaType);
        }
        Element extensionElement = null;
        Node schemaChild = schemaElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                if (schemaType.equals("extension")) {
                    if (extensionElement != null) {
                        throw new InvalidSchemaException("Invalid schema. More than one extension");
                    }
                    extensionElement = childElement;
                } else {
                    throw new InvalidSchemaException("Invalid schema. Only extension element is allowed.");
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
        if (extensionElement == null) {
            throw new InternalErrorException("Internal error. Extension element was expected.");
        }
        String prefixedBaseName = extensionElement.getAttribute("base");
        NamespaceQualifiedName baseName = new NamespaceQualifiedName(prefixedBaseName, schemaElement);
        this.base = model.getNamedSimpleType(baseName);
        if (this.base == null) {
            throw new InvalidSchemaException("Invalid schema. Type definition for base attribute not found. " + baseName);
        }
        schemaChild = extensionElement.getFirstChild();
        schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        while (schemaChild != null) {
            Element childElement = (Element)schemaChild;
            schemaType = childElement.getLocalName();
            if (!schemaType.equals("annotation")) {
                Object attr;
                if (schemaType.equals("attribute")) {
                    attr = model.getAttributeModel(childElement);
                    this.attributes.add((AttributeModel)attr);
                } else if (schemaType.equals("attributeGroup")) {
                    attr = model.getAttributeGroupModel(childElement);
                    this.attributes.add((AttributeGroupModel)attr);
                } else {
                    throw new InvalidSchemaException("Invalid schema. Unexpected type " + schemaType);
                }
            }
            schemaChild = schemaChild.getNextSibling();
            schemaChild = XmlUtils.skipBlankTextAndComments(schemaChild);
        }
    }

    @Override
    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.attributes.validateAndFix(docElement, fixer);
    }

    @Override
    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        Node docChild = docElement.getFirstChild();
        StringBuffer textBuffer = new StringBuffer();
        for (docChild = XmlUtils.skipBlankTextAndComments(docChild); docChild != null && docChild instanceof Text; docChild = docChild.getNextSibling()) {
            Text textNode = (Text)docChild;
            textBuffer.append(textNode.getData());
        }
        while (docChild != null) {
            docChild = fixer.remove(docChild);
        }
        String text = textBuffer.toString();
        String verifiedText = this.base.verifyAndFix(text);
        if (verifiedText != text) {
            docChild = docElement.getFirstChild();
            while (docChild != null) {
                docChild = fixer.remove(docChild);
            }
            fixer.createText(docElement, null, verifiedText);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) throws SchemaException {
        boolean result = this.attributes.definesAttribute(attributeName) || this.base.definesAttribute(attributeName);
        return result;
    }

    @Override
    public boolean definesElement(String elementName) throws SchemaException {
        return this.base.definesElement(elementName);
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        if (child instanceof Attr) {
            return this.getModel((Attr)child);
        }
        return this.base.getModel(child);
    }

    private AttributeModel getModel(Attr child) throws SchemaException {
        AttributeModel result = this.attributes.getModel(child);
        if (result != null) {
            return result;
        }
        return (AttributeModel)this.base.getModel(child);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.base.getSemanticValue(lexicalValue);
    }
}

