/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.DocumentFixer;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModelImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentExtensionImpl;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentImplementation;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleContentRestrictionImpl;
import com.cognos.rspecupgrade.internal.xml.schema.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class SimpleContentModel
implements Type {
    private SimpleContentImplementation implementation;

    SimpleContentModel(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        this.load(schemaElement, model);
    }

    private void load(Element schemaElement, SchemaModelImpl model) throws SchemaException {
        if (!schemaElement.getLocalName().equals("simpleContent")) {
            throw new InternalErrorException("Internal error, simpleContent was expected.");
        }
        for (Node schemaChild = schemaElement.getFirstChild(); schemaChild != null; schemaChild = schemaChild.getNextSibling()) {
            Element childElement;
            String schemaType;
            if (!(schemaChild instanceof Element) || (schemaType = (childElement = (Element)schemaChild).getLocalName()).equals("annotation")) continue;
            if (schemaType.equals("restriction")) {
                if (this.implementation != null) {
                    throw new InvalidSchemaException("InvalidSchema. Restriction or extension already defined.");
                }
                this.implementation = new SimpleContentRestrictionImpl();
                this.implementation.load(schemaElement, model);
                continue;
            }
            if (schemaType.equals("extension")) {
                if (this.implementation != null) {
                    throw new InvalidSchemaException("InvalidSchema. Restriction or extension already defined.");
                }
                this.implementation = new SimpleContentExtensionImpl();
                this.implementation.load(schemaElement, model);
                continue;
            }
            throw new InvalidSchemaException("Invalid schema. Unexpected type: " + schemaType);
        }
        if (this.implementation == null) {
            throw new InvalidSchemaException("Invalid schema. Extension or restriction must be defined");
        }
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws SchemaException {
        return this.implementation.getSemanticValue(lexicalValue);
    }

    public void checkAttributes(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkAttributes(docElement, fixer);
    }

    public void checkChildren(Element docElement, DocumentFixer fixer) throws SchemaException {
        this.implementation.checkChildren(docElement, fixer);
    }

    public boolean definesAttribute(String attributeName) throws SchemaException {
        return this.implementation.definesAttribute(attributeName);
    }

    public boolean definesElement(String elementName) throws SchemaException {
        return this.implementation.definesElement(elementName);
    }

    public ContentModel getModel(Node child) throws SchemaException {
        return this.implementation.getModel(child);
    }
}

