/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSimpleTypeValue;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import org.w3c.dom.Node;

class XsBoolean
implements SimpleType {
    private static final NamespaceQualifiedName name = new NamespaceQualifiedName("http://www.w3.org/2001/XMLSchema", "boolean");
    private static XsBoolean instance = null;

    private XsBoolean() {
    }

    @Override
    public NamespaceQualifiedName getName() {
        return name;
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        return lexicalValue.equals("true") || lexicalValue.equals("false") || lexicalValue.equals("1") || lexicalValue.equals("0");
    }

    @Override
    public String verifyAndFix(String text) {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.getValidValue();
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws InvalidSimpleTypeValue {
        if (lexicalValue.equals("true") || lexicalValue.equals("1")) {
            return new Boolean(true);
        }
        if (lexicalValue.equals("false") || lexicalValue.equals("0")) {
            return new Boolean(false);
        }
        throw new InvalidSimpleTypeValue(lexicalValue, this);
    }

    @Override
    public String getValidValue() {
        return "true";
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        throw new NotImplementedException("Range is not implemented for " + this.getClass().getName());
    }

    @Override
    public void assertIsValidValue(String value, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(value)) {
            throw new InvalidSchemaException(message.getMessage());
        }
    }

    static synchronized XsBoolean getInstance() throws SchemaException {
        if (instance == null) {
            instance = new XsBoolean();
        }
        return instance;
    }
}

