/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.i18n.DateTimeFormat;
import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSimpleTypeValue;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.w3c.dom.Node;

class XsDate
implements SimpleType {
    private static final NamespaceQualifiedName name = new NamespaceQualifiedName("http://www.w3.org/2001/XMLSchema", "date");
    private static Pattern pattern;
    private static Pattern dateWordPattern;
    private static Pattern dateNumberPattern;
    private static XsDate instance;

    private XsDate() {
    }

    @Override
    public NamespaceQualifiedName getName() {
        return name;
    }

    @Override
    public String getValidValue() {
        return "1962-12-06";
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.matches(lexicalValue, pattern)) {
            MatchResult matchResult = matcher.getMatch();
            int year = Integer.parseInt(matchResult.group(1));
            int month = Integer.parseInt(matchResult.group(2));
            int day = Integer.parseInt(matchResult.group(3));
            GregorianCalendar cal = new GregorianCalendar();
            cal.setLenient(true);
            cal.clear();
            cal.set(year, month - 1, day);
            try {
                cal.setLenient(false);
                cal.get(1);
                cal.get(2);
                cal.get(5);
            }
            catch (IllegalArgumentException ex) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String verifyAndFix(String text) {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.fixDate(text);
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws InvalidSimpleTypeValue {
        Perl5Matcher matcher = new Perl5Matcher();
        if (!matcher.matches(lexicalValue, pattern)) {
            throw new InvalidSimpleTypeValue(lexicalValue, this);
        }
        MatchResult matchResult = matcher.getMatch();
        int year = Integer.parseInt(matchResult.group(1));
        int month = Integer.parseInt(matchResult.group(2));
        int day = Integer.parseInt(matchResult.group(3));
        GregorianCalendar cal = new GregorianCalendar();
        cal.setLenient(false);
        cal.clear();
        cal.set(year, month - 1, day);
        try {
            cal.get(1);
            cal.get(2);
            cal.get(5);
            return cal;
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidSimpleTypeValue(lexicalValue, this);
        }
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }

    static synchronized XsDate getInstance() throws SchemaException {
        if (instance == null) {
            try {
                Perl5Compiler compiler = new Perl5Compiler();
                pattern = compiler.compile("^\\s*-?(\\d{4,})-(\\d{2})-(\\d{2})(((\\+|\\-)\\d{2}:\\d{2})|Z)?\\s*$");
                dateWordPattern = compiler.compile("^\\s*(\\d+)\\-([^-\\d]+)-(\\d+)\\s*$");
                dateNumberPattern = compiler.compile("^\\s*(\\d+)\\-(\\d+)-(\\d+)\\s*$");
                instance = new XsDate();
            }
            catch (MalformedPatternException ex) {
                throw new SchemaException(ex);
            }
        }
        return instance;
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        throw new NotImplementedException("Range is not implemented for " + this.getClass().getName());
    }

    private String fixDate(String oldValue) {
        String newValue = this.getValidValue();
        Perl5Matcher dateWordMatcher = new Perl5Matcher();
        if (dateWordMatcher.matches(oldValue, dateWordPattern)) {
            MatchResult matchResult = dateWordMatcher.getMatch();
            Integer[] dateInput = new Integer[]{new Integer(matchResult.group(1)), null, new Integer(matchResult.group(3))};
            int year = this.findYear(dateInput);
            int month = this.findMonth(matchResult.group(2));
            int day = this.findDay(dateInput);
            newValue = this.formatDate(year, month, day);
        } else {
            Perl5Matcher dateNumberMatcher = new Perl5Matcher();
            if (dateNumberMatcher.matches(oldValue, dateNumberPattern)) {
                MatchResult matchResult = dateNumberMatcher.getMatch();
                Integer[] dateInput = new Integer[]{new Integer(matchResult.group(1)), new Integer(matchResult.group(2)), new Integer(matchResult.group(3))};
                int year = this.findYear(dateInput);
                int month = this.findMonth(dateInput);
                int day = this.findDay(dateInput);
                newValue = this.formatDate(year, month, day);
            }
        }
        return newValue;
    }

    private int findYear(Integer[] dateInput) {
        int result = 2001;
        if (dateInput[0] != null && dateInput[2] != null) {
            if (dateInput[0] >= dateInput[2]) {
                result = dateInput[0];
                dateInput[0] = null;
            } else {
                result = dateInput[2];
                dateInput[2] = null;
            }
        } else {
            int index = -1;
            for (int i = 0; i < dateInput.length; ++i) {
                if (dateInput[i] == null || index >= 0 && dateInput[i] <= dateInput[index]) continue;
                index = i;
            }
            if (index >= 0) {
                result = dateInput[index];
                dateInput[index] = null;
            }
        }
        if (result < 1000) {
            result = result < 50 ? (result += 2000) : (result += 1900);
        }
        return result;
    }

    private int findMonth(Integer[] dateInput) {
        int month;
        if ((dateInput[0] == null || dateInput[2] == null) && dateInput[1] != null && (month = dateInput[1].intValue()) >= 1 && month <= 12) {
            dateInput[1] = null;
            return month;
        }
        int index = -1;
        for (int i = 0; i < dateInput.length; ++i) {
            if (dateInput[i] == null) continue;
            if (index < 0) {
                index = i;
                continue;
            }
            if (dateInput[i] >= dateInput[index]) continue;
            index = i;
        }
        int result = 1;
        if (index >= 0) {
            result = dateInput[index];
            dateInput[index] = null;
            if (result < 1 || result > 12) {
                result = 1;
            }
        }
        return result;
    }

    private int findMonth(String monthName) {
        return this.findMonth(monthName, Locale.ENGLISH);
    }

    private int findMonth(String monthName, Locale locale) {
        DateTimeFormat format = new DateTimeFormat(locale, 10);
        String[] months = format.getMonths();
        int monthIndex = this.find(monthName, months);
        if (monthIndex >= 0) {
            return monthIndex + 1;
        }
        months = format.getShortMonths();
        monthIndex = this.find(monthName, months);
        if (monthIndex >= 0) {
            return monthIndex + 1;
        }
        return 1;
    }

    private int findDay(Integer[] dateInput) {
        int index = -1;
        for (int i = 0; i < dateInput.length; ++i) {
            if (dateInput[i] == null) continue;
            if (index < 0) {
                index = i;
                continue;
            }
            if (dateInput[i] >= 32 || dateInput[i] <= dateInput[index]) continue;
            index = i;
        }
        int result = 1;
        if (index >= 0) {
            result = dateInput[index];
            dateInput[index] = null;
        }
        return result;
    }

    private String formatDate(int year, int month, int day) {
        StringBuffer buffer = new StringBuffer(10);
        if (year < 1000) {
            buffer.append('0');
            if (year < 100) {
                buffer.append('0');
                if (year < 10) {
                    buffer.append('0');
                }
            }
        }
        buffer.append(Integer.toString(year));
        buffer.append('-');
        if (month < 10) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(month));
        buffer.append('-');
        if (day < 10) {
            buffer.append('0');
        }
        buffer.append(Integer.toString(day));
        String result = buffer.toString();
        return result;
    }

    private int find(String object, String[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (object == objects[i]) {
                return i;
            }
            if (object == null) continue;
            if (object.equals(objects[i])) {
                return i;
            }
            if (object.compareToIgnoreCase(objects[i]) != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void assertIsValidValue(String value, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(value)) {
            throw new InvalidSchemaException(message.getMessage());
        }
    }

    static {
        instance = null;
    }
}

