/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InternalErrorException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.LongRange;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionPattern;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionRange;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import org.w3c.dom.Node;

abstract class XsFiniteSetIntegralNumber
implements SimpleType {
    private final RestrictionPattern pattern;
    private final RestrictionRange boundaries;

    public XsFiniteSetIntegralNumber(long initialMinimum, long initialMaximum) throws SchemaException {
        LongRange range = new LongRange(null, Long.toString(initialMinimum), Long.toString(initialMaximum), null);
        this.boundaries = new RestrictionRange(range);
        this.pattern = new RestrictionPattern("\\s*[\\-\\+]?\\s*\\d+\\s*");
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        return this.boundaries.newRangeInstance(minExclusive, minInclusive, maxInclusive, maxExclusive);
    }

    public long getValidIntegralValue() throws SchemaException {
        try {
            return Long.parseLong(this.boundaries.getValidValue(null));
        }
        catch (NumberFormatException e) {
            throw new InternalErrorException(e);
        }
    }

    protected static long parseIntegralNumber(String text) {
        if ((text = text.trim()).startsWith("+")) {
            text = text.substring(1);
        }
        long result = Long.parseLong(text);
        return result;
    }

    @Override
    public boolean isValidValue(String text) {
        if (!this.pattern.isValidValue(text)) {
            return false;
        }
        return this.boundaries.isValidValue(text);
    }

    @Override
    public void assertIsValidValue(String lexicalValue, MessageGenerator message) throws InvalidSchemaException {
        this.pattern.assertIsValidValue(lexicalValue, message);
        this.boundaries.assertIsValidValue(lexicalValue, message);
    }

    @Override
    public String getValidValue() throws SchemaException {
        long num = this.getValidIntegralValue();
        return Long.toString(num);
    }

    @Override
    public String verifyAndFix(String text) throws SchemaException {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.getValidValue();
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }
}

