/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.schema;

import com.cognos.rspecupgrade.internal.xml.schema.ContentModel;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.InvalidSimpleTypeValue;
import com.cognos.rspecupgrade.internal.xml.schema.MessageGenerator;
import com.cognos.rspecupgrade.internal.xml.schema.NamespaceQualifiedName;
import com.cognos.rspecupgrade.internal.xml.schema.NotImplementedException;
import com.cognos.rspecupgrade.internal.xml.schema.Range;
import com.cognos.rspecupgrade.internal.xml.schema.RestrictionPattern;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaException;
import com.cognos.rspecupgrade.internal.xml.schema.SimpleType;
import com.cognos.rspecupgrade.internal.xml.schema.XsNMTOKEN;
import java.util.Vector;
import org.w3c.dom.Node;

public class XsNMTOKENS
implements SimpleType {
    private static XsNMTOKENS instance;
    private final RestrictionPattern pattern;
    private static final NamespaceQualifiedName name;

    private XsNMTOKENS() throws InvalidSchemaException {
        String tokenPattern = XsNMTOKEN.getTokenPattern();
        String patternStr = "\\s*(" + tokenPattern + ")" + "(\\s+(" + tokenPattern + "))*" + "\\s*";
        this.pattern = new RestrictionPattern(patternStr);
    }

    @Override
    public NamespaceQualifiedName getName() {
        return name;
    }

    @Override
    public boolean isValidValue(String lexicalValue) {
        return this.pattern.isValidValue(lexicalValue);
    }

    @Override
    public void assertIsValidValue(String value, MessageGenerator message) throws InvalidSchemaException {
        if (!this.isValidValue(value)) {
            throw new InvalidSchemaException(message.getMessage());
        }
    }

    @Override
    public String verifyAndFix(String text) throws SchemaException {
        if (this.isValidValue(text)) {
            return text;
        }
        return this.getValidValue();
    }

    @Override
    public String getValidValue() {
        return "xsnmtokens";
    }

    @Override
    public Range newRangeInstance(String minExclusive, String minInclusive, String maxInclusive, String maxExclusive) throws SchemaException {
        throw new NotImplementedException("Range is not implemented for " + this.getClass().getName());
    }

    @Override
    public boolean definesAttribute(String attributeName) {
        return false;
    }

    @Override
    public boolean definesElement(String elementName) {
        return false;
    }

    @Override
    public ContentModel getModel(Node child) throws SchemaException {
        return null;
    }

    @Override
    public Object getSemanticValue(String lexicalValue) throws InvalidSimpleTypeValue {
        if (!this.isValidValue(lexicalValue)) {
            throw new InvalidSimpleTypeValue(lexicalValue, this);
        }
        String[] tokens = lexicalValue.split("\\s");
        Vector<String> result = new Vector<String>(tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            if (tokens[i].length() <= 0) continue;
            result.add(tokens[i]);
        }
        return result;
    }

    static synchronized XsNMTOKENS getInstance() throws SchemaException {
        if (instance == null) {
            instance = new XsNMTOKENS();
        }
        return instance;
    }

    static {
        name = new NamespaceQualifiedName("http://www.w3.org/2001/XMLSchema", "NMTOKENS");
    }
}

