/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.xpath.parsetree;

import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationListener;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationState;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Expression;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AllChildElements
implements Expression {
    private String namespace;

    public AllChildElements(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public LinkedList<EvaluationState> evaluate(Node context, Object state, EvaluationListener listener) {
        LinkedList<EvaluationState> result = new LinkedList<EvaluationState>();
        for (Node child = context.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            String childNamespace = childElement.getNamespaceURI();
            if (this.namespace != null && !this.namespace.equals(childNamespace)) continue;
            Object newListenerState = listener.descending(state, child);
            EvaluationState intermediateState = new EvaluationState(child, newListenerState);
            result.add(intermediateState);
        }
        return result;
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("  ");
        }
        writer.print("AllChildElements namespace=");
        writer.print(this.namespace);
        writer.println();
    }
}

