/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.internal.xml.xpath.parsetree;

import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationListener;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.EvaluationState;
import com.cognos.rspecupgrade.internal.xml.xpath.parsetree.Expression;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamedAttribute
implements Expression {
    private String localName;

    public NamedAttribute(String localName) {
        this.localName = localName;
    }

    @Override
    public LinkedList<EvaluationState> evaluate(Node context, Object state, EvaluationListener listener) {
        LinkedList<EvaluationState> result = new LinkedList<EvaluationState>();
        Element parentElement = (Element)context;
        NamedNodeMap attributes = parentElement.getAttributes();
        int nbAttributes = attributes.getLength();
        for (int attributeNb = 0; attributeNb < nbAttributes; ++attributeNb) {
            Attr attribute = (Attr)attributes.item(attributeNb);
            if (!this.matches(attribute)) continue;
            Object newListenerState = listener.descending(state, context);
            EvaluationState intermediateState = new EvaluationState(attribute, newListenerState);
            result.add(intermediateState);
        }
        return result;
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        for (int i = 0; i < indent; ++i) {
            writer.print("  ");
        }
        writer.print("NamedAttribute ");
        writer.print(" ");
        writer.print("localname=");
        writer.print(this.localName);
        writer.println();
    }

    private boolean matches(Attr attribute) {
        String contextLocalName = attribute.getName();
        return contextLocalName.equals(this.localName);
    }
}

