/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.api;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.api.UpgradeReportSpecificationApi;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.LogImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.UntranslatedMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddMessages;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class UpgradeReportSpecificationApiImpl
implements UpgradeReportSpecificationApi {
    Messages messages;
    Log log;
    IConfiguration configuration;

    public UpgradeReportSpecificationApiImpl(String messageLocaleString) {
        this.createLogAndMessages(messageLocaleString);
    }

    public UpgradeReportSpecificationApiImpl(String messageLocaleString, Properties properties) throws Exception {
        this(messageLocaleString);
        this.createConfiguration(properties);
    }

    private void createLogAndMessages(String messageLocale) {
        try {
            this.messages = new MessagesImpl(messageLocale);
        }
        catch (Exception ex) {
            this.messages = new UntranslatedMessages();
        }
        this.log = new LogImpl(this.messages);
    }

    private Document createOriginalReportSpecification(Reader inputSpecReader) throws Exception {
        if (inputSpecReader == null) {
            throw new IOException("Input reader may not be null");
        }
        try {
            Document document = XmlUtils.readDocument(inputSpecReader);
            return document;
        }
        catch (Exception ex) {
            throw new Exception("RSU_SPC_INVALID_XML_REPORT_SPEC" + ex.getLocalizedMessage());
        }
        finally {
            inputSpecReader.close();
        }
    }

    protected void createConfiguration(Properties properties) throws Exception {
        try {
            this.configuration = Configuration.createWithTaintedAdditionalProperties(this.messages, properties);
        }
        catch (Exception ex) {
            this.log.error(RspecUpgradeMessage.RSU_UPG_UPGRADE_EXCEPTION(ex.getLocalizedMessage()));
            this.configuration = new Configuration(this.messages);
        }
    }

    private Document createErrorDocument() throws Exception {
        Document errorDoc = XmlUtils.createDocument();
        AddMessages.addMessages(errorDoc, this.log, this.messages);
        return errorDoc;
    }

    private void reportToWriter(Document upgradedReport, Writer outputSpecWriter) throws Exception {
        if (outputSpecWriter == null) {
            throw new Exception("The output spec writer may not be null");
        }
        XmlUtils.writeDocument(outputSpecWriter, (Node)upgradedReport);
        outputSpecWriter.close();
    }

    Document upgradeReport(Document inputReportDoc) throws UpgradeException {
        UpgradeReportSpecification upgrader = new UpgradeReportSpecification(this.messages, this.configuration);
        return upgrader.upgrade(inputReportDoc);
    }

    private Document createUpgradedReport(Document inputReportDoc) throws Exception {
        if (this.log.hasMessages()) {
            return this.createErrorDocument();
        }
        try {
            return this.upgradeReport(inputReportDoc);
        }
        catch (Throwable ex) {
            this.log.error(RspecUpgradeMessage.RSU_UPG_UPGRADE_EXCEPTION(ex.getLocalizedMessage()));
            return this.createErrorDocument();
        }
    }

    @Override
    public void upgrade(Reader inputSpecReader, Writer outputSpecWriter) throws Exception {
        if (inputSpecReader == null) {
            throw new Exception("Input reader may not be null");
        }
        if (outputSpecWriter == null) {
            throw new Exception("The output writer may not be null");
        }
        try {
            Document inputReportDoc = this.createOriginalReportSpecification(inputSpecReader);
            Document upgradedReport = this.createUpgradedReport(inputReportDoc);
            this.reportToWriter(upgradedReport, outputSpecWriter);
        }
        catch (Exception ex) {
            throw new Exception(this.messages.getString(RspecUpgradeMessage.RSU_UPG_UPGRADE_EXCEPTION(ex.getLocalizedMessage())));
        }
    }
}

