/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.cm_plugin;

import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.plugin.Interface.CMUpgradeMessage;
import com.cognos.cm.plugin.Interface.CMUpgradeResult;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.NamespaceChanger;
import com.cognos.rspecupgrade.rsupgrade.cm_plugin.CmUpgradeFactory;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.IUpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Message;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.OutputReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20NovRtm;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class UpgradeReportSpecWorker {
    private final Messages messages;
    private final IConfiguration config;
    private static final String PROP_SPECIFICATION = "specification";
    private final CmUpgradeFactory factory;

    public UpgradeReportSpecWorker(CmUpgradeFactory factory) throws UpgradeException {
        this.factory = factory;
        this.messages = factory.createMessages();
        this.config = this.factory.createConfiguration(this.messages);
    }

    public void initialize(CMPluginDescriptor desc, ICCLConfiguration cfg) throws Exception {
    }

    public void terminate() throws Exception {
    }

    private boolean isBeringNovRTMUpgradeToBeUsed(CMUpgradeData data) {
        boolean bBeringNovRTM = false;
        boolean bPluginVersionSpecified = data.getProperties().contains("PLUGIN_VERSION");
        if (bPluginVersionSpecified) {
            String pluginVersion = (String)data.getPropertyValue("PLUGIN_VERSION");
            bBeringNovRTM = pluginVersion.equals("2.001");
        }
        return bBeringNovRTM;
    }

    private Document readXmlDocument(String oldReportSpec) throws IOException, Exception {
        try (StringReader reader = new StringReader(oldReportSpec);){
            Document document = XmlUtils.readDocument(reader);
            return document;
        }
    }

    private void storeResults(CMUpgradeResult result, Document upgradedReportSpec, Log messageLog) throws Exception, IOException {
        if (messageLog.hasErrorMessages()) {
            result.setUpgradeStatus(2);
            result.setNextAction(1);
        } else {
            StringWriter writer = new StringWriter();
            XmlUtils.writeDocument(writer, (Node)upgradedReportSpec);
            writer.close();
            String sUpgradedReportSpec = writer.toString();
            HashMap<String, String> mapNewSpec = new HashMap<String, String>();
            mapNewSpec.put(PROP_SPECIFICATION, sUpgradedReportSpec);
            result.setData(mapNewSpec);
            result.setUpgradeStatus(1);
            result.setNextAction(1);
        }
    }

    private boolean isReportInNamespace(Document report, String namespace) {
        Element root = report.getDocumentElement();
        String actualNamespace = root.getNamespaceURI();
        boolean result = namespace.equals(actualNamespace);
        return result;
    }

    private boolean isBeringNovRtmReport(Document reportSpecification) {
        return this.isReportInNamespace(reportSpecification, ReportSpecification20NovRtm.targetNamespace);
    }

    private boolean isBeringReport(Document reportSpecification) {
        return this.isReportInNamespace(reportSpecification, ReportSpecification20.targetNamespace);
    }

    private boolean isCurrentVersion(Document reportSpecification) {
        return this.isReportInNamespace(reportSpecification, OutputReportSpecification.targetNamespace);
    }

    private Document getReportToUpgrade(CMUpgradeData data) throws Exception {
        String oldReportSpec = (String)data.getPropertyValue(PROP_SPECIFICATION);
        Document origSpec = this.readXmlDocument(oldReportSpec);
        if (!this.isBeringNovRTMUpgradeToBeUsed(data)) {
            return origSpec;
        }
        if (!this.isBeringReport(origSpec)) {
            return origSpec;
        }
        NamespaceChanger changer = new NamespaceChanger(ReportSpecification20.targetNamespace, ReportSpecification20NovRtm.targetNamespace);
        return changer.upgrade(origSpec);
    }

    public CMUpgradeResult upgrade(CMUpgradeData data) {
        if (data == null) {
            return null;
        }
        CMUpgradeResult result = new CMUpgradeResult();
        try {
            try {
                this.dumpCMUpgradeData(data, this.config);
                Document origSpec = this.getReportToUpgrade(data);
                Document upgradedReportSpec = this.upgrade(origSpec, data, this.config);
                if (upgradedReportSpec == null) {
                    return null;
                }
                Log messageLog = UpgradeReportSpecification.extractUpgradeMessages(upgradedReportSpec, this.messages);
                this.addCMUpgradeMessages(messageLog, result);
                this.storeResults(result, upgradedReportSpec, messageLog);
            }
            catch (Exception anException) {
                String msg = anException.getLocalizedMessage();
                this.setUpgradeFailed(result, msg, this.messages);
            }
            this.dumpCmResult(result, this.config);
        }
        catch (Exception anException) {
            String msg = anException.getLocalizedMessage();
            this.setUpgradeFailed(result, msg, this.messages);
        }
        return result;
    }

    private void setUpgradeFailed(CMUpgradeResult result, String reason, Messages msgs) {
        if (reason == null || reason.length() == 0) {
            try {
                reason = msgs.getString(RspecUpgradeMessage.RSU_UPG_ERROR_UPGRADE_FAILED());
            }
            catch (Exception ex) {
                reason = "RSU_UPG_ERROR_UPGRADE_FAILED";
            }
        }
        CMUpgradeMessage cmMessage = new CMUpgradeMessage(reason, 40000);
        Vector<CMUpgradeMessage> cmMessageList = new Vector<CMUpgradeMessage>();
        cmMessageList.add(cmMessage);
        result.setMessages(cmMessageList);
        result.setUpgradeStatus(2);
        result.setNextAction(1);
    }

    protected IUpgradeReportSpecification createUpgrader(IConfiguration config) throws UpgradeException {
        IUpgradeReportSpecification upgrader = this.factory.createUpgrader(this.messages, config);
        return upgrader;
    }

    private boolean isReportToBeUpgraded(CMUpgradeData data, Document reportToUpgrade) {
        if (this.isCurrentVersion(reportToUpgrade)) {
            return false;
        }
        if (this.isBeringNovRtmReport(reportToUpgrade)) {
            return true;
        }
        boolean bUpgradeReports = data.getProperties().contains("UPGRADE_REPORT");
        return bUpgradeReports;
    }

    private Document upgrade(Document origSpec, CMUpgradeData data, IConfiguration config) throws Exception {
        Element root = XmlUtils.getRoot(origSpec);
        String namespace = root.getNamespaceURI();
        if (namespace == null) {
            String msg = this.messages.getString(RspecUpgradeMessage.RSU_UPG_INVALID_REPORT_SPEC());
            throw new Exception(msg);
        }
        if (!this.isReportToBeUpgraded(data, origSpec)) {
            return null;
        }
        IUpgradeReportSpecification upgrader = this.createUpgrader(config);
        Document upgradedReportSpec = upgrader.upgrade(origSpec);
        return upgradedReportSpec;
    }

    private void addCMUpgradeMessages(Log messageLog, CMUpgradeResult cmUpgradeResult) {
        int[] severityMap = new int[]{50000, 30000, 20000};
        Vector<CMUpgradeMessage> messageList = new Vector<CMUpgradeMessage>();
        for (Message msg : messageLog.getMessages()) {
            messageList.add(new CMUpgradeMessage(msg.getText(), severityMap[msg.getSeverity()]));
        }
        if (!messageList.isEmpty()) {
            cmUpgradeResult.setMessages(messageList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCMUpgradeData(CMUpgradeData data, IConfiguration config) {
        File debugFile = config.getIntermediateFileName("cm_input", "txt");
        if (debugFile != null) {
            try {
                FileOutputStream outFileStream = new FileOutputStream(debugFile);
                OutputStreamWriter outStreamWriter = new OutputStreamWriter((OutputStream)outFileStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outStreamWriter);
                PrintWriter debugWriter = new PrintWriter(bufferedWriter);
                try {
                    boolean upgradeReport = data.getProperties().contains("UPGRADE_REPORT");
                    debugWriter.println("UPGRADE_REPORT");
                    debugWriter.println(upgradeReport);
                    debugWriter.println();
                    boolean pluginVersionSpecified = data.getProperties().contains("PLUGIN_VERSION");
                    if (pluginVersionSpecified) {
                        String pluginVersion = (String)data.getPropertyValue("PLUGIN_VERSION");
                        debugWriter.println("PLUGIN_VERSION");
                        debugWriter.println(pluginVersion);
                        debugWriter.println();
                    }
                    debugWriter.println("PROP_SPECIFICATION");
                    String srcReportSpec = (String)data.getPropertyValue(PROP_SPECIFICATION);
                    debugWriter.println(srcReportSpec);
                    debugWriter.println();
                }
                finally {
                    debugWriter.close();
                    outStreamWriter.close();
                    outFileStream.close();
                }
            }
            catch (IOException anIOException) {
                anIOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpCmResult(CMUpgradeResult result, IConfiguration config) {
        File resultFile = config.getIntermediateFileName("cm_output", "txt");
        if (resultFile != null) {
            try {
                FileOutputStream outFileStream = new FileOutputStream(resultFile);
                OutputStreamWriter outStreamWriter = new OutputStreamWriter((OutputStream)outFileStream, "UTF-8");
                BufferedWriter bufferedWriter = new BufferedWriter(outStreamWriter);
                PrintWriter resultWriter = new PrintWriter(bufferedWriter);
                try {
                    if (result == null) {
                        resultWriter.println("RESULT is null");
                    } else {
                        resultWriter.println("MESSAGES");
                        List cmResultMessages = result.getMessages();
                        if (cmResultMessages != null) {
                            ListIterator msgIter = cmResultMessages.listIterator();
                            while (msgIter.hasNext()) {
                                CMUpgradeMessage upgradeMessage = (CMUpgradeMessage)msgIter.next();
                                resultWriter.print("(");
                                resultWriter.print(upgradeMessage.getSeverity());
                                resultWriter.print(") ");
                                resultWriter.println(upgradeMessage.getMessage());
                            }
                        }
                        resultWriter.println();
                        resultWriter.println("UPGRADE STATUS");
                        resultWriter.println(result.getUpgradeStatus());
                        resultWriter.println();
                        resultWriter.println("NEXT ACTION");
                        resultWriter.println(result.getNextAction());
                        resultWriter.println();
                        Map resultData = result.getData();
                        if (resultData == null) {
                            resultWriter.println("result data is null");
                        } else {
                            resultWriter.println("PROP_SPECIFICATION");
                            if (!resultData.containsKey(PROP_SPECIFICATION)) {
                                resultWriter.println("No PROP_SPECIFICATION in resultData");
                            } else {
                                Object propSpec = resultData.get(PROP_SPECIFICATION);
                                resultWriter.println(propSpec);
                            }
                        }
                    }
                }
                finally {
                    resultWriter.close();
                    outStreamWriter.close();
                    outFileStream.close();
                }
            }
            catch (IOException anIOException) {
                anIOException.printStackTrace();
            }
        }
    }
}

