/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.configuration;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.rspecupgrade.internal.xml.schema.SchemaModel;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.ActualCurrentTime;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.CurrentTimeGenerator;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.PropertySecurityCheck;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.PropertySecurityCheckImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.ResourceFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.UpgradeProperties;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.OutputReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.SchemaRegistry;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaModelCache;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaVersionUtils;
import com.ibm.json.java.JSON;
import com.ibm.json.java.JSONObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class Configuration
implements IConfiguration {
    static final SchemaRegistry schemaRegistry = new SchemaRegistry();
    private File binDir = null;
    private Messages messages;
    private UpgradeProperties properties;
    private static Counter intermediateFileCounter = new Counter();
    CurrentTimeGenerator currentTimeGenerator = null;
    ResourceFinder resourceFinder = null;
    private static SchemaModelCache schemaModels = new SchemaModelCache();
    private static boolean reportSchemasLoaded = false;

    private void configure(Messages messages, File configurationFile, Properties overrideProperties, PropertySecurityCheck propertyChecker) throws UpgradeException {
        if (propertyChecker != null && overrideProperties != null) {
            propertyChecker.verify(messages, overrideProperties);
        }
        this.messages = messages;
        this.properties = new UpgradeProperties(this.messages, configurationFile, overrideProperties);
        this.resourceFinder = new ResourceFinder(this.messages, this.getResourcesDirectory());
        this.loadRecentAndTargetReportSchemas();
        OutputReportSpecification.setTargetNamespace(SchemaVersionUtils.getNamespaceFromVersion(this.getRSpecSchemaVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecentAndTargetReportSchemas() {
        int numSchemasToLoadAtStartup = this.getNumRecentReportSchemasToPreloadAtStartup();
        if (numSchemasToLoadAtStartup <= 0) {
            return;
        }
        if (!reportSchemasLoaded) {
            try {
                for (int i = 0; i < numSchemasToLoadAtStartup; ++i) {
                    String schema = OutputReportSpecification.getRecentReportSchema(i);
                    if (schema == null) continue;
                    this.getSchemaModel(schema);
                }
            }
            catch (UpgradeException upgradeException) {
            }
            finally {
                reportSchemasLoaded = true;
            }
        }
    }

    private Configuration() {
    }

    public Configuration(Messages messages) throws UpgradeException {
        this.configure(messages, null, null, null);
    }

    public Configuration(Messages messages, File configurationFile, Properties overrideProperties) throws UpgradeException {
        this.configure(messages, configurationFile, overrideProperties, null);
    }

    public static Configuration createWithTaintedAdditionalProperties(Messages translatedMessages, Properties additionalProperties) throws UpgradeException {
        Configuration configuration = new Configuration();
        configuration.configure(translatedMessages, null, additionalProperties, new PropertySecurityCheckImpl());
        return configuration;
    }

    @Override
    public synchronized CurrentTimeGenerator getCurrentTimeGenerator() throws UpgradeException {
        try {
            if (this.currentTimeGenerator == null) {
                String generatorClassName = this.properties.getString("com.cognos.rspecupgrade.rsupgrade.configuration.currentTime", ActualCurrentTime.class.getName());
                Class<?> generatorClass = Class.forName(generatorClassName);
                this.currentTimeGenerator = (CurrentTimeGenerator)generatorClass.newInstance();
            }
            return this.currentTimeGenerator;
        }
        catch (Exception e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    @Override
    public File getBinDir() throws UpgradeException {
        if (this.binDir == null) {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            String binDirString = cfg.resolveEffectivePath("../bin");
            File dir = new File(binDirString);
            if (!dir.isDirectory()) {
                String msg = this.messages.getString(RspecUpgradeMessage.RSU_UPG_ERROR_BINDIR_NOT_DIRECTORY(dir.getPath()));
                throw new UpgradeException(msg);
            }
            this.binDir = dir;
        }
        return this.binDir;
    }

    @Override
    public File getReportSpecificationSchemaFile(String reportSpecNamespace) throws UpgradeException {
        File v5SchemaFile;
        File binDir = this.getBinDir();
        File rootDir = binDir.getParentFile();
        File rspecDir = new File(rootDir, "schemas");
        String schemaPathName = schemaRegistry.getSchemaPath(reportSpecNamespace);
        if (schemaPathName == null) {
            String version = this.getRSpecSchemaVersion();
            if (version != null && reportSpecNamespace.equals(SchemaVersionUtils.getNamespaceFromVersion(version))) {
                schemaPathName = SchemaVersionUtils.getSchemaRelativePathfromVersion(version);
            } else {
                return null;
            }
        }
        if (!(v5SchemaFile = new File(rspecDir, schemaPathName)).canRead()) {
            return null;
        }
        return v5SchemaFile;
    }

    private String getRSpecSchemaVersion() throws UpgradeException {
        String result = null;
        try {
            File binDir = this.getBinDir();
            File rootDir = binDir.getParentFile();
            File rspecDir = new File(rootDir, "schemas");
            File vFile = new File(rspecDir, "rspec/version.json");
            if (vFile.exists()) {
                FileInputStream versionFile = new FileInputStream(vFile);
                JSONObject obj = (JSONObject)JSON.parse((InputStream)versionFile);
                result = (String)obj.get((Object)"version");
                versionFile.close();
            }
        }
        catch (Exception e) {
            throw new UpgradeException(e);
        }
        return result;
    }

    @Override
    public URL getXslScript(String scriptName) throws UpgradeException {
        String resourceName = "resources/xsl/" + scriptName;
        return this.resourceFinder.getResourceUrl(resourceName);
    }

    @Override
    public boolean getUpgradeInfoMessage() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.upgradeInfoMessage");
    }

    @Override
    public boolean getValidateInputReportSpec() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.validateInput");
    }

    @Override
    public boolean getValidateOutputReportSpec() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.validateOutput");
    }

    @Override
    public boolean getRewriteCqe() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.rewriteCqe");
    }

    @Override
    public boolean getRewriteCRX() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.rewriteCrx");
    }

    @Override
    public int getMaxSchemaFixups() {
        return this.properties.getInteger("com.cognos.rspecupgrade.rsupgrade.maxSchemaFixups");
    }

    @Override
    public String[] getPluginPreprocess() {
        return this.properties.getStringArray("com.cognos.rspecupgrade.rsupgrade.plugin.preprocess");
    }

    @Override
    public String[] getPluginPostprocess() {
        return this.properties.getStringArray("com.cognos.rspecupgrade.rsupgrade.plugin.postprocess");
    }

    @Override
    public boolean getPageBreakText() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.pageBreakText");
    }

    @Override
    public boolean getInteractivePageBreakByFrame() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.interactivePageBreakByFrame");
    }

    @Override
    public boolean getLayoutNameGenerationBaltic() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.1");
    }

    @Override
    public boolean getLayoutNameGenerationBering() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.20");
    }

    @Override
    public boolean getLayoutNameGenerationBlaring() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.layoutNameGeneration.30");
    }

    @Override
    public EmbedOriginalSpecificationEnumeration getEmbedOriginalSpecification() {
        String value = this.properties.getString("com.cognos.rspecupgrade.rsupgrade.embedOriginalSpecification", "NEVER");
        return EmbedOriginalSpecificationEnumeration.fromString(value);
    }

    @Override
    public boolean getEmbedInternalError() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.embedInternalError");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getIntermediateFileName(String suffix, String extension) {
        File result = null;
        if (this.getWriteIntermediateFiles()) {
            String prefix = this.getIntermediateFilePrefix();
            StringBuffer name = new StringBuffer(prefix);
            Counter counter = intermediateFileCounter;
            synchronized (counter) {
                for (int leadingZeros = 1000000; Configuration.intermediateFileCounter.value < leadingZeros; leadingZeros /= 10) {
                    name.append('0');
                }
                name.append(Integer.toString(Configuration.intermediateFileCounter.value));
                ++Configuration.intermediateFileCounter.value;
                if (suffix != null) {
                    name.append(suffix);
                }
                name.append('.');
                name.append(extension);
                result = new File(name.toString());
            }
        }
        return result;
    }

    @Override
    public boolean getEnableShareResultSet() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.enableShareResultSet");
    }

    @Override
    public boolean getEnableWorkOrder2628() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.enableWorkOrder2628");
    }

    @Override
    public String getTargetnamespace() {
        return this.properties.getString("com.cognos.rspecupgrade.rsupgrade.targetNamespace", OutputReportSpecification.targetNamespace);
    }

    private boolean getWriteIntermediateFiles() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.writeIntermediateFiles");
    }

    private String getIntermediateFilePrefix() {
        return this.properties.getString("com.cognos.rspecupgrade.rsupgrade.intermediateFilePrefix", "/tmp/upgrade_");
    }

    private File getResourcesDirectory() throws UpgradeException {
        File rsupgrade = new File(this.getBinDir(), "rsupgrade");
        return rsupgrade;
    }

    @Override
    public SchemaModel getSchemaModel(String schemaNamespace) throws UpgradeException {
        return schemaModels.getModel(this, schemaNamespace);
    }

    @Override
    public boolean getEnableChecksumGenerator() {
        return this.properties.getBoolean("com.cognos.rspecupgrade.rsupgrade.enableChecksumGenerator");
    }

    @Override
    public int getNumRecentReportSchemasToPreloadAtStartup() {
        return this.properties.getInteger("com.cognos.rspecupgrade.rsupgrade.numRecentReportSchemasToPreload");
    }

    private static class Counter {
        int value = 1;

        private Counter() {
        }
    }

    public static class EmbedOriginalSpecificationEnumeration {
        public static final EmbedOriginalSpecificationEnumeration NEVER = new EmbedOriginalSpecificationEnumeration();
        public static final EmbedOriginalSpecificationEnumeration WARNING = new EmbedOriginalSpecificationEnumeration();
        public static final EmbedOriginalSpecificationEnumeration ERROR = new EmbedOriginalSpecificationEnumeration();
        public static final EmbedOriginalSpecificationEnumeration ALWAYS = new EmbedOriginalSpecificationEnumeration();

        private EmbedOriginalSpecificationEnumeration() {
        }

        static EmbedOriginalSpecificationEnumeration fromString(String value) {
            if (value == null) {
                return WARNING;
            }
            if (value.equals("NEVER")) {
                return NEVER;
            }
            if (value.equals("WARNING")) {
                return WARNING;
            }
            if (value.equals("ERROR")) {
                return ERROR;
            }
            if (value.equals("ALWAYS")) {
                return ALWAYS;
            }
            return WARNING;
        }
    }
}

