/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.configuration;

import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class ResourceFinder {
    private Messages translatedMessages;
    private File resourceDirectory;

    public ResourceFinder(Messages messages, File resourceDir) {
        this.translatedMessages = messages;
        this.resourceDirectory = resourceDir;
    }

    private URI urlToUri(URL url) throws UpgradeInternalErrorException {
        URI uri;
        String urlString = url.toString();
        try {
            uri = new URI(urlString);
        }
        catch (URISyntaxException e) {
            String msg = this.translatedMessages.getString(RspecUpgradeMessage.RSU_UPG_URL_TO_URI_CONVERSION_FAILED_BAD_URI(urlString));
            throw new UpgradeInternalErrorException(msg);
        }
        try {
            URL uriAsUrl = uri.toURL();
            if (!uriAsUrl.equals(url)) {
                String msg = this.translatedMessages.getString(RspecUpgradeMessage.RSU_UPG_URL_TO_URI_CONVERSION_FAILED(url.toString(), uri.toString()));
                throw new UpgradeInternalErrorException(msg);
            }
        }
        catch (MalformedURLException e) {
            throw new UpgradeInternalErrorException(e);
        }
        return uri;
    }

    protected URL getNonFileResourceUrl(String resourceName) throws UpgradeException {
        URL url = ClassLoader.getSystemResource(resourceName);
        if (url == null) {
            url = this.getClass().getResource(resourceName);
        }
        return url;
    }

    protected File getResourceFile(String resourceName) throws UpgradeInternalErrorException {
        File resource = new File(this.resourceDirectory, resourceName);
        if (!resource.canRead()) {
            String message = this.translatedMessages.getString(RspecUpgradeMessage.RSU_UPG_UNABLE_TO_LOAD_RESOURCE(resourceName));
            throw new UpgradeInternalErrorException(message);
        }
        return resource;
    }

    public URI getResourceUri(String resourceName) throws UpgradeException {
        URL url = this.getNonFileResourceUrl(resourceName);
        if (url != null) {
            return this.urlToUri(url);
        }
        File resource = this.getResourceFile(resourceName);
        return resource.toURI();
    }

    public URL getResourceUrl(String resourceName) throws UpgradeException {
        URL url = this.getNonFileResourceUrl(resourceName);
        if (url != null) {
            return url;
        }
        File resource = this.getResourceFile(resourceName);
        try {
            URI resourceUri = resource.toURI();
            URL resourceUrl = resourceUri.toURL();
            return resourceUrl;
        }
        catch (MalformedURLException e) {
            throw new UpgradeInternalErrorException(e);
        }
    }
}

