/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.engine;

import com.cognos.rspecupgrade.internal.io.IOException;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.Configuration;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.IUpgradeReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.OutputNamespaceContext;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContextImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeInternalErrorException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Log;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.LogImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Message;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessagesImpl;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.SystemLog;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.OutputReportSpecification;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._20novrtm.NovRtmNamespaceChanger;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._minorUpgrade.MinorNamespaceChange;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.PostProcessingCleanup;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.ProblemsDetectedMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.RemoveOldMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter.QueryExpressionRewriter;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.c8.expressionrewriter.ReportExpressionRewriter;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.plugin.PluginPostprocessor;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.plugin.PluginPreprocessor;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddChecksum;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddLogMessages;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AddUpgradePerformedComment;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.AnchorMessageReferences;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.EmbedOriginalReport;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaValidatorUpgrader;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.SchemaVersionUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.UpgradeNotes;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UnknownReportVersionUpgrader;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.Upgrader;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgraderRegistry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpgradeReportSpecification
implements IUpgradeReportSpecification {
    private final UpgradeSessionContext upgradeSession;
    private final UpgraderRegistry upgraderRegistry;

    public UpgradeReportSpecification(Messages messages, IConfiguration config) throws UpgradeException {
        this.upgradeSession = new UpgradeSessionContextImpl(messages, config);
        this.upgraderRegistry = new UpgraderRegistry(config);
    }

    public static void main(String[] args) {
        try {
            MessagesImpl messages = new MessagesImpl();
            File configurationFile = null;
            File inputSpecFile = null;
            File outputSpecFile = null;
            boolean novRtm = false;
            boolean helpWanted = false;
            boolean usage = false;
            int arg = 0;
            while (arg < args.length) {
                if (args[arg].equals("-h") | args[arg].equals("--help")) {
                    ++arg;
                    usage = true;
                    helpWanted = true;
                    continue;
                }
                if (args[arg].equals("--NovRtm")) {
                    novRtm = true;
                    ++arg;
                    continue;
                }
                if (args[arg].equals("-i") | args[arg].equals("--input")) {
                    if (++arg >= args.length) {
                        usage = true;
                        continue;
                    }
                    inputSpecFile = new File(args[arg]);
                    ++arg;
                    continue;
                }
                if (!(args[arg].equals("-o") | args[arg].equals("--output"))) break;
                if (++arg >= args.length) {
                    usage = true;
                    continue;
                }
                outputSpecFile = new File(args[arg]);
                ++arg;
            }
            if (inputSpecFile == null) {
                if (arg < args.length) {
                    inputSpecFile = new File(args[arg]);
                    ++arg;
                } else {
                    usage = true;
                }
            }
            if (outputSpecFile == null) {
                if (arg < args.length) {
                    outputSpecFile = new File(args[arg]);
                    ++arg;
                } else {
                    usage = true;
                }
            }
            if (arg != args.length) {
                usage = true;
            }
            if (usage) {
                String msg = messages.getString(RspecUpgradeMessage.RSU_UPG_UPGRADE_REPORT_SPECIFICATION_USAGE());
                System.out.println(msg);
                if (helpWanted) {
                    System.exit(0);
                } else {
                    StringBuffer command = new StringBuffer();
                    for (int i = 0; i < args.length; ++i) {
                        command.append('\"');
                        command.append(args[i]);
                        command.append('\"');
                        command.append(' ');
                    }
                    System.out.println();
                    String output = messages.getString(RspecUpgradeMessage.RSU_UPG_UPGRADE_CMD(command.toString()));
                    System.out.println(output);
                    System.exit(1);
                }
            }
            if (!inputSpecFile.isFile()) {
                String output = messages.getString(RspecUpgradeMessage.RSU_UPG_ORIGINAL_REPORT_FILE_NOT_READABLE(inputSpecFile.getCanonicalPath()));
                throw new UpgradeException(output);
            }
            Configuration config = new Configuration(messages, configurationFile, null);
            UpgradeReportSpecification upgrader = new UpgradeReportSpecification(messages, config);
            Document inputSpecDoc = null;
            try {
                inputSpecDoc = XmlUtils.readDocument(inputSpecFile);
            }
            catch (IOException ex) {
                String error = messages.getString(RspecUpgradeMessage.RSU_UPG_INVALID_FILE(inputSpecFile.getAbsolutePath(), Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), Integer.toString(ex.getCharacterNumber()), ex.getLocalizedMessage()));
                System.err.println(error);
                System.exit(1);
            }
            if (novRtm) {
                NovRtmNamespaceChanger namespaceChanger = new NovRtmNamespaceChanger();
                inputSpecDoc = namespaceChanger.upgrade(inputSpecDoc);
            }
            Document v5Spec = upgrader.upgrade(inputSpecDoc);
            XmlUtils.writeDocument(outputSpecFile, (Node)v5Spec);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
        System.exit(0);
    }

    void embedInternalError(Document doc, Throwable t) throws UpgradeException {
        if (t == null) {
            return;
        }
        Node insertLocation = null;
        insertLocation = doc.getLastChild();
        if (insertLocation == null) {
            insertLocation = doc;
        }
        StringBuffer buffer = new StringBuffer();
        String msg = t.getLocalizedMessage();
        buffer.append(msg);
        buffer.append("\n");
        StackTraceElement[] traces = t.getStackTrace();
        for (int i = 0; i < traces.length; ++i) {
            String trace = traces[i].toString();
            buffer.append(trace);
            buffer.append("\n");
        }
        buffer.append("\n");
        String message = buffer.toString();
        XmlUtils.insertComment(insertLocation, message);
        Throwable cause = t.getCause();
        this.embedInternalError(doc, cause);
    }

    Document createErrorDocument(Throwable t, Messages translatedMessages) throws UpgradeException {
        try {
            Document errorDoc = XmlUtils.createDocument();
            Element report = errorDoc.createElementNS(OutputReportSpecification.targetNamespace, ReportSpecification50._report);
            errorDoc.appendChild(report);
            report.setAttribute("xmlns", OutputReportSpecification.targetNamespace);
            report.setAttribute(ReportSpecification50._expressionLocale, "en-us");
            Element layouts = XmlUtils.createChildElement(report, ReportSpecification50._layouts);
            XmlUtils.createChildElement(layouts, ReportSpecification50._layout);
            Element upgradeInfo = XmlUtils.createChildElement(report, ReportSpecification50._upgradeInfo);
            Element upgradeMessaegs = XmlUtils.createChildElement(upgradeInfo, ReportSpecification50._upgradeMessages);
            Element upgradeMessage = XmlUtils.createChildElement(upgradeMessaegs, ReportSpecification50._upgradeMessage);
            upgradeMessage.setAttribute(ReportSpecification50._type, ReportSpecification50._error);
            String message = translatedMessages.getString(RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_SEE_ADMIN());
            XmlUtils.setText(upgradeMessage, message);
            if (this.upgradeSession.getConfiguration().getEmbedInternalError()) {
                XmlUtils.insertComment(errorDoc, "embedInternalError is on");
                this.embedInternalError(errorDoc, t);
            }
            return errorDoc;
        }
        catch (Exception e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    @Override
    public Document upgrade(Document inputSpecDoc) throws UpgradeException {
        return this.upgrade(inputSpecDoc, this.upgradeSession.getConfiguration().getTargetnamespace());
    }

    @Override
    public Document upgrade(Document inputSpecDoc, String targetNamespace) throws UpgradeException {
        UpgradeSessionContextImpl upgradeSession = new UpgradeSessionContextImpl(this.upgradeSession.getTranslatedMessages(), this.upgradeSession.getConfiguration());
        return this.doUpgrade(inputSpecDoc, targetNamespace, upgradeSession);
    }

    void logExceptionToFile(File file, Throwable exception) {
        try {
            if (file == null) {
                return;
            }
            FileOutputStream fileStream = new FileOutputStream(file);
            PrintStream printStream = new PrintStream((OutputStream)fileStream, true, "UTF-8");
            exception.printStackTrace(printStream);
            printStream.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void logExceptionToFile(UpgradeSessionContext upgradeSession, Throwable exception) {
        try {
            File file = upgradeSession.getConfiguration().getIntermediateFileName("logException", "txt");
            if (file != null) {
                this.logExceptionToFile(file, exception);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void logException(UpgradeSessionContext upgradeSession, Throwable exception) {
        try {
            SystemLog log = upgradeSession.getSystemLog();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.close();
            String msg = stringWriter.toString();
            log.logError(msg);
            this.logExceptionToFile(upgradeSession, exception);
        }
        catch (Throwable t) {
            this.logExceptionToFile(upgradeSession, exception);
            this.logExceptionToFile(upgradeSession, t);
        }
    }

    private void addUpgraders(LinkedList<UpgradePipelineElement> upgradePipeline, String sourceNamespace, String targetNamespace, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LinkedList<Upgrader> upgraders = this.upgraderRegistry.getUpgraders(sourceNamespace, targetNamespace);
        if (upgraders == null) {
            if (!this.handleMinorUpgrade(upgradePipeline, sourceNamespace, targetNamespace)) {
                UnknownReportVersionUpgrader upgrader = new UnknownReportVersionUpgrader(sourceNamespace, targetNamespace);
                upgrader.appendPipelineElements(upgradePipeline, upgradeSession);
            }
        } else {
            for (Upgrader upgrader : upgraders) {
                upgrader.appendPipelineElements(upgradePipeline, upgradeSession);
            }
            if (upgraders.getLast() != null) {
                this.handleMinorUpgrade(upgradePipeline, upgraders.getLast().getDestinationNameSpace(), targetNamespace);
            }
        }
    }

    private boolean handleMinorUpgrade(LinkedList<UpgradePipelineElement> upgradePipeline, String namespace, String targetNamespace) {
        float version = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(namespace)).floatValue();
        float targetVersion = Float.valueOf(SchemaVersionUtils.getVersionFromNamespace(targetNamespace)).floatValue();
        if (version >= UpgraderRegistry.minorUpgradeBase && targetVersion > version && Math.floor(targetVersion) == Math.floor(version)) {
            upgradePipeline.addLast(new MinorNamespaceChange(namespace, targetNamespace));
            return true;
        }
        return false;
    }

    private LinkedList<UpgradePipelineElement> buildUpgradePipeline(String sourceNamespace, String targetNamespace, Document doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        boolean rewriteCRX;
        LinkedList<UpgradePipelineElement> upgradePipeline = new LinkedList<UpgradePipelineElement>();
        upgradePipeline.addLast(new PluginPreprocessor());
        upgradePipeline.addLast(new RemoveOldMessages());
        if (upgradeSession.getConfiguration().getValidateInputReportSpec()) {
            upgradePipeline.addLast(new SchemaValidatorUpgrader());
        }
        this.addUpgraders(upgradePipeline, sourceNamespace, targetNamespace, upgradeSession);
        boolean rewriteCQE = upgradeSession.getConfiguration().getRewriteCqe();
        if (rewriteCQE) {
            upgradePipeline.addLast(new QueryExpressionRewriter());
        }
        if (rewriteCRX = upgradeSession.getConfiguration().getRewriteCRX()) {
            upgradePipeline.addLast(new ReportExpressionRewriter(upgradeSession.getTranslatedMessages()));
        }
        upgradePipeline.addLast(new AddUpgradePerformedComment(sourceNamespace, targetNamespace));
        upgradePipeline.addLast(new PostProcessingCleanup());
        upgradePipeline.addLast(new AnchorMessageReferences());
        if (this.upgradeSession.getConfiguration().getValidateOutputReportSpec()) {
            upgradePipeline.addLast(new SchemaValidatorUpgrader());
        }
        upgradePipeline.addLast(new AddLogMessages());
        upgradePipeline.addLast(new UpgradeNotes.RemoveUnusedMessageIds());
        upgradePipeline.addLast(new ProblemsDetectedMessage());
        Configuration.EmbedOriginalSpecificationEnumeration embedReportSpec = this.upgradeSession.getConfiguration().getEmbedOriginalSpecification();
        if (embedReportSpec != Configuration.EmbedOriginalSpecificationEnumeration.NEVER) {
            Document originalDoc = (Document)doc.cloneNode(true);
            upgradePipeline.addLast(new EmbedOriginalReport(originalDoc));
        }
        if (upgradeSession.getConfiguration().getEnableChecksumGenerator()) {
            upgradePipeline.addLast(new AddChecksum());
        }
        upgradePipeline.addLast(new PluginPostprocessor());
        return upgradePipeline;
    }

    Document doUpgrade(Document doc, String targetNamespace, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            if (doc == null) {
                throw new NullPointerException("doc may not be null");
            }
            Element root = XmlUtils.getRoot(doc);
            String sourceNamespace = root.getNamespaceURI();
            if (targetNamespace.equals(sourceNamespace)) {
                return doc;
            }
            XmlUtils.writeIntermediateDocument(doc, "original", this.upgradeSession.getConfiguration());
            LinkedList<UpgradePipelineElement> upgradePipeline = this.buildUpgradePipeline(sourceNamespace, targetNamespace, doc, upgradeSession);
            doc = this.executeUpgradePipeline(doc, upgradePipeline, upgradeSession);
            return doc;
        }
        catch (Throwable t) {
            try {
                this.logException(upgradeSession, t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.createErrorDocument(t, this.upgradeSession.getTranslatedMessages());
        }
    }

    public static Log extractUpgradeMessages(Document v5Spec, Messages messages) throws UpgradeException {
        LogImpl result = new LogImpl(messages);
        UpgradeReportSpecification.extractUpgradeMessages(v5Spec, result);
        return result;
    }

    private static void extractUpgradeMessages(Document v5Spec, Log log) throws UpgradeException {
        try {
            OutputNamespaceContext nsContext = new OutputNamespaceContext();
            nsContext.add("output", OutputReportSpecification.targetNamespace);
            String path = "/output:report/output:upgradeInfo/output:upgradeMessages/output:upgradeMessage";
            NodeList messageNodes = XmlUtils.selectNodeList(v5Spec, path, nsContext);
            int nbMessageNodes = messageNodes.getLength();
            for (int messageNodeIndex = 0; messageNodeIndex < nbMessageNodes; ++messageNodeIndex) {
                Element messageNode = (Element)messageNodes.item(messageNodeIndex);
                String strSeverity = messageNode.getAttribute(ReportSpecification20._type);
                int severity = 0;
                if (ReportSpecification20._warning.equals(strSeverity)) {
                    severity = 1;
                } else if (ReportSpecification20._info.equals(strSeverity)) {
                    severity = 2;
                }
                String messageText = XmlUtils.getText(messageNode);
                Message msg = new Message(messageText, severity);
                log.logTranslatedMessage(msg);
            }
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private Document executeUpgradePipeline(Document doc, LinkedList<UpgradePipelineElement> upgraders, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (doc == null) {
            throw new UpgradeInternalErrorException("Internal error. doc may not be null");
        }
        for (UpgradePipelineElement upgrader : upgraders) {
            doc = upgrader.upgrade(doc, upgradeSession);
            if (doc == null) {
                throw new UpgradeInternalErrorException("Doc may not be null. Returned by " + upgrader.getClass().getName());
            }
            XmlUtils.writeIntermediateDocument(doc, upgrader.getClass().getName(), this.upgradeSession.getConfiguration());
        }
        return doc;
    }
}

