/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.messages;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.MessageTemplate;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.Messages;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.UntranslatedMessages;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessagesImpl
implements Messages {
    private static final String BUNDLE_NAME = "rspecupgrademsgs";
    private Locale msgLocale;
    private ResourceBundle bundle = null;

    public MessagesImpl(Locale locale) {
        this.msgLocale = locale;
    }

    public MessagesImpl(String locale) throws Exception {
        this(MessagesImpl.newLocale(locale));
    }

    public MessagesImpl() {
        this((Locale)null);
    }

    @Override
    public Locale getLocale() {
        return this.msgLocale;
    }

    private synchronized ResourceBundle getBundle() {
        if (this.bundle == null) {
            if (this.msgLocale != null) {
                try {
                    this.bundle = ResourceBundle.getBundle(BUNDLE_NAME, this.msgLocale);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (this.bundle == null) {
                try {
                    this.bundle = ResourceBundle.getBundle(BUNDLE_NAME);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.bundle;
    }

    @Override
    public String getString(MessageTemplate messageTemplate) {
        try {
            return messageTemplate.apply(this.getBundle());
        }
        catch (Exception ex) {
            UntranslatedMessages messageSource = new UntranslatedMessages();
            return messageSource.getString(messageTemplate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Locale newLocale(String strLocale) throws Exception {
        String slanguage = null;
        String sCountry = null;
        if (strLocale == null) {
            ICCLConfiguration cfg = CCLConfigurationFactory.getInstance();
            try {
                strLocale = cfg.getValue("serverLocale", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (strLocale != null && strLocale.length() > 0) {
            if (strLocale.length() > 2) {
                int langSep = strLocale.indexOf("-");
                if (langSep < 0) throw new Exception("Invalid user locale specified: " + strLocale);
                sCountry = strLocale.substring(langSep + 1);
                slanguage = strLocale.substring(0, langSep);
            } else {
                slanguage = strLocale;
                sCountry = "";
            }
        }
        Locale result = null;
        if (slanguage == null) return Locale.getDefault();
        if (slanguage.length() <= 0) return Locale.getDefault();
        if (sCountry == null) return new Locale(slanguage, "");
        if (sCountry.length() != 0) return new Locale(slanguage, sCountry);
        return new Locale(slanguage, "");
    }
}

