/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.ParseTreeException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.configuration.IConfiguration;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.ExpressionQueryFixer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AliasMapping {
    BalticQueryFinder queryFinder = new BalticQueryFinder();
    private Locale expressionLocale;
    IConfiguration config;

    public AliasMapping(Locale expressionLocale, IConfiguration config) {
        this.expressionLocale = expressionLocale;
        this.config = config;
    }

    public Document mapDataItems(Document v4Spec, AliasMap aliasMap, UpgradeSessionContext upgradeSession) throws UpgradeException {
        v4Spec = this.mapLayoutExpresionDataItems(v4Spec, aliasMap, upgradeSession);
        XmlUtils.writeIntermediateDocument(v4Spec, "v4_mapLayoutExpressionDataItems", this.config);
        v4Spec = this.mapVariables(v4Spec, aliasMap, upgradeSession);
        XmlUtils.writeIntermediateDocument(v4Spec, "v4_mapVariables", this.config);
        return v4Spec;
    }

    private Document mapLayoutExpresionDataItems(Document v4Spec, AliasMap aliasMap, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (v4Spec == null) {
            return null;
        }
        if (aliasMap.isIdentityMap()) {
            return v4Spec;
        }
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        Element layoutList = XmlUtils.getFirstChildElementByName(report, "layoutList");
        if (layoutList == null) {
            return v4Spec;
        }
        NodeList expressionList = layoutList.getElementsByTagName("expression");
        if (expressionList == null) {
            return v4Spec;
        }
        int nbExpressions = expressionList.getLength();
        for (int expressionNb = 0; expressionNb < nbExpressions; ++expressionNb) {
            Element expression = (Element)expressionList.item(expressionNb);
            this.replaceDataItems(expression, aliasMap, upgradeSession);
        }
        return v4Spec;
    }

    private void replaceDataItems(Element expressionElement, AliasMap aliasMap, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String expression = XmlUtils.getText(expressionElement);
        StringReader reader = new StringReader(expression);
        IExpression parseTree = null;
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (Exception ex) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR(expression);
            upgradeSession.getUpgradeNotes().addUpgradeNote(expressionElement, 0, message, true);
            return;
        }
        ExpressionQueryFixer queryFixer = new ExpressionQueryFixer();
        parseTree = queryFixer.fixQueries(parseTree, expressionElement, this.queryFinder, expression, false, upgradeSession);
        BooleanValue changed = new BooleanValue(false);
        parseTree = this.mapQueries(parseTree, aliasMap, changed);
        String newExpression = parseTree.toString(this.expressionLocale);
        XmlUtils.removeChildren(expressionElement);
        Document doc = expressionElement.getOwnerDocument();
        Text newExpressionTextNode = doc.createTextNode(newExpression);
        expressionElement.appendChild(newExpressionTextNode);
    }

    private Document mapVariables(Document v4Spec, AliasMap aliasMap, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (v4Spec == null) {
            return null;
        }
        if (aliasMap.isIdentityMap()) {
            return v4Spec;
        }
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        Element variableList = XmlUtils.getFirstChildElementByName(report, "variableList");
        if (variableList == null) {
            return v4Spec;
        }
        NodeList expressionList = variableList.getElementsByTagName("expression");
        if (expressionList == null) {
            return v4Spec;
        }
        int nbExpressions = expressionList.getLength();
        Element expressionElement = null;
        for (int expressionNb = 0; expressionNb < nbExpressions; ++expressionNb) {
            Node child;
            expressionElement = (Element)expressionList.item(expressionNb);
            String expressionString = XmlUtils.getText(expressionElement);
            StringReader reader = new StringReader(expressionString);
            IExpression parseTree = null;
            try {
                CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
                parseTree = parser.start();
            }
            catch (CrxParserException error) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR(expressionString);
                upgradeSession.getUpgradeNotes().addUpgradeNote(expressionElement, 0, message, true);
            }
            if (parseTree == null) continue;
            BooleanValue changed = new BooleanValue(false);
            parseTree = this.mapQueries(parseTree, aliasMap, changed);
            if (!changed.get()) continue;
            String newExpressionString = parseTree.toString(this.expressionLocale);
            do {
                if ((child = expressionElement.getFirstChild()) == null) continue;
                expressionElement.removeChild(child);
            } while (child != null);
            Text newExpressionTextNode = v4Spec.createTextNode(newExpressionString);
            expressionElement.appendChild(newExpressionTextNode);
        }
        return v4Spec;
    }

    IExpression mapQueries(IExpression parseTree, AliasMap aliasMap, BooleanValue changed) throws UpgradeException {
        if (aliasMap.isIdentityMap()) {
            return parseTree;
        }
        Set<NameExpression> names = GetNames.getNames(parseTree);
        if (names.size() == 0) {
            return parseTree;
        }
        Hashtable<NameExpression, NameExpression> replacements = new Hashtable<NameExpression, NameExpression>();
        for (NameExpression name : names) {
            String toQuery;
            String fromQuery = name.getQueryName();
            if (fromQuery == null || (toQuery = aliasMap.getNewQueryName(fromQuery)).equals(fromQuery)) continue;
            String dataItem = name.getDataItem();
            NameExpression to = new NameExpression();
            to.add(toQuery);
            to.add(dataItem);
            replacements.put(name, to);
        }
        if (replacements.size() == 0) {
            return parseTree;
        }
        try {
            parseTree = parseTree.replace(replacements, changed);
        }
        catch (ParseTreeException e) {
            UpgradeException.throwNestedException(e);
        }
        return parseTree;
    }
}

