/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BalticBurstElementCleanup
implements UpgradePipelineElement {
    private void verifyBurstKey(Element key, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String refQuery = key.getAttribute("refQuery");
            Document v4Spec = XmlUtils.getOwnerDoc(key);
            Element query = BalticQueryFinder.findQueryElement(v4Spec, refQuery);
            if (query == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_KEY_QUERY_UNDEFINED(refQuery);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)key, 0, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)key, message);
                return;
            }
            String refLevel = key.getAttribute("refLevel");
            Element level = XmlUtils.getNamedElementWithAttributeValue(query, "level", "name", refLevel);
            if (level == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_KEY_LEVEL_UNDEFINED(refQuery, refLevel);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)key, 0, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)key, message);
                return;
            }
            if (!key.hasAttribute("refItem")) {
                return;
            }
            String refItem = key.getAttribute("refItem");
            Element item = XmlUtils.getNamedElementWithAttributeValue(level, "item", "refItem", refLevel);
            if (item == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_KEY_ITEM_UNDEFINED(refQuery, refLevel, refItem);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)key, 1, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)key.getAttributeNode("refItem"), message);
                return;
            }
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void verifyBurstKeys(Element burst, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList keys = XmlUtils.getChildElementsByName(burst, "key");
        int nbKeys = keys.getLength();
        for (int i = nbKeys - 1; i >= 0; --i) {
            Element key = (Element)keys.item(i);
            this.verifyBurstKey(key, upgradeSession);
        }
    }

    private void verifyBurstRecipient(Element recipient, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String refQuery = recipient.getAttribute("refQuery");
            Document v4Spec = XmlUtils.getOwnerDoc(recipient);
            Element query = BalticQueryFinder.findQueryElement(v4Spec, refQuery);
            if (query == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_RECIPIENT_QUERY_UNDEFINED(refQuery);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)recipient, 0, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)recipient, message);
                return;
            }
            String refItem = recipient.getAttribute("refItem");
            Element item = XmlUtils.getNamedElementWithAttributeValue(query, "dataItem", "name", refItem);
            if (item == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_RECIPIENT_ITEM_UNDEFINED(refQuery, refItem);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)recipient, 0, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)recipient, message);
                return;
            }
            String type = recipient.getAttribute("type");
            if (!("auto".equals(type) || "email".equals(type) || "directory".equals(type))) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_BALTIC_BURST_RECIPIENT_TYPE_UNDEFINED(type);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)recipient, 0, message);
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)recipient, message);
                return;
            }
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void verifyBurstRecipients(Element burst, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList recipients = XmlUtils.getChildElementsByName(burst, "recipient");
        int nbRecipients = recipients.getLength();
        for (int i = nbRecipients - 1; i >= 0; --i) {
            Element recipient = (Element)recipients.item(i);
            this.verifyBurstRecipient(recipient, upgradeSession);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getRoot(origSpec);
        if (report == null) {
            return origSpec;
        }
        Element burst = XmlUtils.getFirstChildElementByName(report, "burst");
        if (burst == null) {
            return origSpec;
        }
        this.verifyBurstKeys(burst, upgradeSession);
        this.verifyBurstRecipients(burst, upgradeSession);
        return origSpec;
    }
}

