/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.xpath.XPathGenerator;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BalticEmptyChart
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(origSpec, "report");
        if (report == null) {
            return origSpec;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, "layoutList");
        if (layouts == null) {
            return origSpec;
        }
        NodeList lines = layouts.getElementsByTagName("line");
        int nbLines = lines.getLength();
        for (int i = 0; i < nbLines; ++i) {
            Element line = (Element)lines.item(i);
            this.checkLine(line, context);
        }
        return origSpec;
    }

    private void checkLine(Element line, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element chartMember = XmlUtils.getFirstChildElementByName(line, "chartMember");
        if (chartMember == null) {
            this.logEmptyLine(upgradeSession, line);
        }
    }

    private void logEmptyLine(UpgradeSessionContext upgradeSession, Element line) throws UpgradeException {
        String type = XmlUtils.getName(line);
        String path = XPathGenerator.getXPath(line);
        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_BALTIC_NO_CHARTMEMBERS(type, path);
        upgradeSession.getUpgradeNotes().addUpgradeNote(line, 2, msg, true);
    }
}

