/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.RefDataItem;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.QueryFinder;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BalticQueryFinder
implements QueryFinder {
    public static Element findRefQueryElement(Element layoutElement) {
        while (layoutElement != null && !layoutElement.hasAttribute("refQuery")) {
            Node parent = layoutElement.getParentNode();
            if (!(parent instanceof Element)) {
                return null;
            }
            layoutElement = (Element)parent;
        }
        return layoutElement;
    }

    public static boolean queryContainsDataItem(Element query, RefDataItem refDataItem) {
        Element fact;
        Element factList;
        String queryName;
        String refQuery = refDataItem.getQueryName();
        if (refQuery != null && !(queryName = query.getAttribute("name")).equals(refQuery)) {
            return false;
        }
        String dataItem = refDataItem.getDataItem();
        Element selection = XmlUtils.getFirstChildElementByName(query, "selection");
        Element dataItemElement = XmlUtils.getFirstChildElementByNameWithAttributeValue(selection, "dataItem", "name", dataItem);
        if (dataItemElement != null) {
            return true;
        }
        Element dimensionInfo = XmlUtils.getFirstChildElementByName(query, "dimensionInfo");
        return dimensionInfo != null && (factList = XmlUtils.getFirstChildElementByName(dimensionInfo, "factList")) != null && (fact = XmlUtils.getFirstChildElementByNameWithAttributeValue(factList, "fact", "name", dataItem)) != null;
    }

    @Override
    public String findQueryName(Element elem, String dataItem) {
        Element refQueryElem = BalticQueryFinder.findRefQueryElement(elem);
        if (refQueryElem == null) {
            return null;
        }
        String queryName = refQueryElem.getAttribute("refQuery");
        Document v4Spec = elem.getOwnerDocument();
        Element query = BalticQueryFinder.findQueryElement(v4Spec, queryName);
        if (query == null) {
            return null;
        }
        if (BalticQueryFinder.queryContainsDataItem(query, dataItem)) {
            return queryName;
        }
        Node parent = elem.getParentNode();
        if (!(parent instanceof Element)) {
            return null;
        }
        Element parentElement = (Element)parent;
        return this.findQueryName(parentElement, dataItem);
    }

    public Set<String> findQueriesWithDataItem(Document v4, String dataItemName) {
        HashSet<String> result = new HashSet<String>();
        Element report = XmlUtils.getRoot(v4);
        if (report == null) {
            return result;
        }
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return result;
        }
        NodeList biQueryList = querySet.getElementsByTagName("BIQuery");
        int nbQueries = biQueryList.getLength();
        for (int queryNb = 0; queryNb < nbQueries; ++queryNb) {
            Element biQuery = (Element)biQueryList.item(queryNb);
            if (!BalticQueryFinder.queryContainsDataItem(biQuery, dataItemName)) continue;
            String queryName = biQuery.getAttribute("name");
            result.add(queryName);
        }
        return result;
    }

    public static boolean queryContainsDataItem(Element query, String dataItem) {
        NodeList nodes = query.getElementsByTagName("item");
        if (BalticQueryFinder.anyElementHasDataItem(nodes, dataItem)) {
            return true;
        }
        nodes = query.getElementsByTagName("dataItem");
        return BalticQueryFinder.anyElementHasDataItem(nodes, dataItem);
    }

    private static boolean anyElementHasDataItem(NodeList nodes, String nameValue) {
        int nbNodes = nodes.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            String value;
            Element elem = (Element)nodes.item(i);
            if (elem.hasAttribute("name") && (value = elem.getAttribute("name")).equals(nameValue)) {
                return true;
            }
            if (elem.hasAttribute("refLevel") && (value = elem.getAttribute("refLevel")).equals(nameValue)) {
                return true;
            }
            if (elem.hasAttribute("refItem") && (value = elem.getAttribute("refItem")).equals(nameValue)) {
                return true;
            }
            if (!elem.hasAttribute("alias") || !(value = elem.getAttribute("alias")).equals(nameValue)) continue;
            return true;
        }
        return false;
    }

    public static Element findQueryElement(Document v4Spec, String queryName) {
        Element report = XmlUtils.getFirstChildElementByName(v4Spec, "report");
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return null;
        }
        Element query = XmlUtils.getFirstChildElementByNameWithAttributeValue(querySet, "BIQuery", "name", queryName);
        return query;
    }

    public static String findLevelForItem(Element query, String refItem) {
        if (query == null) {
            return null;
        }
        Element balticSummary = XmlUtils.getFirstChildElementByName(query, "summary");
        if (balticSummary != null) {
            NodeList itemList = balticSummary.getElementsByTagName("item");
            int nbItems = itemList.getLength();
            for (int i = 0; i < nbItems; ++i) {
                String refItemValue;
                Element item = (Element)itemList.item(i);
                if (!item.hasAttribute("refItem") || !refItem.equals(refItemValue = item.getAttribute("refItem"))) continue;
                Element level = (Element)item.getParentNode();
                String refLevel = level.getAttribute("refLevel");
                return refLevel;
            }
        }
        return null;
    }

    public static String findLevelFirstKeyForItem(Document v4Spec, Element query, String refItem) {
        if (query == null) {
            return null;
        }
        Element cubeNode = BalticQueryFinder.findCube(v4Spec, query);
        if (cubeNode != null) {
            NodeList itemList = cubeNode.getElementsByTagName("item");
            int nbItems = itemList.getLength();
            for (int i = 0; i < nbItems; ++i) {
                String isKey;
                Element keyItem;
                int j;
                Element item = (Element)itemList.item(i);
                String itemName = null;
                if (item.hasAttribute("alias")) {
                    itemName = item.getAttribute("alias");
                } else if (item.hasAttribute("refItem")) {
                    itemName = item.getAttribute("refItem");
                }
                if (itemName == null || !refItem.equals(itemName)) continue;
                Element level = (Element)item.getParentNode();
                NodeList levelItemList = level.getElementsByTagName("item");
                int nbKeys = levelItemList.getLength();
                for (j = 0; j < nbKeys; ++j) {
                    keyItem = (Element)levelItemList.item(j);
                    isKey = keyItem.getAttribute("key");
                    if (!isKey.equals("true")) continue;
                    String keyItemValue = null;
                    keyItemValue = keyItem.hasAttribute("alias") ? keyItem.getAttribute("alias") : keyItem.getAttribute("refItem");
                    return keyItemValue;
                }
                levelItemList = level.getElementsByTagName("dataItem");
                nbKeys = levelItemList.getLength();
                for (j = 0; j < nbKeys; ++j) {
                    keyItem = (Element)levelItemList.item(j);
                    isKey = keyItem.getAttribute("key");
                    if (!isKey.equals("true")) continue;
                    String keyItemValue = keyItem.getAttribute("name");
                    return keyItemValue;
                }
            }
        }
        return null;
    }

    public static Element findCube(Document v4Spec, String queryName) {
        Element query = BalticQueryFinder.findQueryElement(v4Spec, queryName);
        if (query == null) {
            return null;
        }
        return BalticQueryFinder.findCube(v4Spec, query);
    }

    public static Element findCube(Document v4Spec, Element query) {
        if (query == null) {
            return null;
        }
        Element cubeNode = null;
        Element cubeReference = XmlUtils.getFirstChildElementByName(query, "cubeReference");
        if (cubeReference != null) {
            Element referencedQuery;
            String cubeReferenceName = cubeReference.getAttribute("refQuery");
            if (cubeReferenceName != "" && (referencedQuery = BalticQueryFinder.findQueryElement(v4Spec, cubeReferenceName)) != null) {
                cubeNode = XmlUtils.getFirstChildElementByName(referencedQuery, "cube");
            }
        } else {
            cubeNode = XmlUtils.getFirstChildElementByName(query, "cube");
        }
        return cubeNode;
    }

    public static Collection<Element> findTabularModels(Document reportSpec, String queryName) {
        LinkedList<Element> models = new LinkedList<Element>();
        BalticQueryFinder.findTabularModels(models, reportSpec, queryName);
        return models;
    }

    private static boolean findTabularModels(LinkedList<Element> models, Document reportSpec, String queryName) {
        Element query = BalticQueryFinder.findQueryElement(reportSpec, queryName);
        if (query == null) {
            return false;
        }
        boolean modelFound = BalticQueryFinder.addTabularModels(models, query);
        boolean bl = modelFound = BalticQueryFinder.addTabularReferences(models, reportSpec, query) || modelFound;
        if (modelFound) {
            return true;
        }
        modelFound = BalticQueryFinder.dereferenceCube(models, reportSpec, query);
        return modelFound;
    }

    private static boolean dereferenceCube(LinkedList<Element> models, Document reportSpec, Element query) {
        Element cubeReference = XmlUtils.getFirstChildElementByName(query, "cubeReference");
        if (cubeReference != null) {
            String queryName = cubeReference.getAttribute("refQuery");
            return BalticQueryFinder.findTabularModels(models, reportSpec, queryName);
        }
        return false;
    }

    private static boolean addTabularReferences(LinkedList<Element> models, Document reportSpec, Element query) {
        boolean modelFound = false;
        NodeList tabularReferenceList = query.getElementsByTagName("tabularReference");
        int nbReferences = tabularReferenceList.getLength();
        for (int i = 0; i < nbReferences; ++i) {
            Element tabularReference = (Element)tabularReferenceList.item(i);
            String queryName = tabularReference.getAttribute("refQuery");
            modelFound = BalticQueryFinder.findTabularModels(models, reportSpec, queryName) || modelFound;
        }
        return modelFound;
    }

    private static boolean addTabularModels(LinkedList<Element> models, Element query) {
        boolean modelFound = false;
        NodeList tabularModelList = query.getElementsByTagName("tabularModel");
        int nbNodels = tabularModelList.getLength();
        for (int i = 0; i < nbNodels; ++i) {
            Element tabularModel = (Element)tabularModelList.item(i);
            models.addLast(tabularModel);
            modelFound = true;
        }
        return modelFound;
    }

    public static Element findQueryElement(Element elemInLayout) {
        Element refQueryElement = BalticQueryFinder.findRefQueryElement(elemInLayout);
        if (refQueryElement == null) {
            return null;
        }
        String queryName = refQueryElement.getAttribute("refQuery");
        Element biQueryElement = BalticQueryFinder.findQueryElement(elemInLayout.getOwnerDocument(), queryName);
        return biQueryElement;
    }

    public static boolean isSummaryQuery(Element biQueryElement) {
        Element summaryElement = XmlUtils.getFirstChildElementByName(biQueryElement, "summary");
        return summaryElement != null;
    }

    public static Vector<String> findQueryNamesInContext(Element elemInLayout) {
        Vector<String> queryNames = new Vector<String>();
        Element currentFrame = BalticQueryFinder.findRefQueryElement(elemInLayout);
        while (currentFrame != null) {
            Element parentElement;
            String queryName = currentFrame.getAttribute("refQuery");
            if (queryNames.indexOf(queryName) == -1) {
                queryNames.add(queryName);
            }
            if ((parentElement = XmlUtils.getParentElement(currentFrame)) == null) break;
            currentFrame = BalticQueryFinder.findRefQueryElement(parentElement);
        }
        return queryNames;
    }

    public static Vector<String> findLevelNamesOfDimension(Element dimension) {
        Vector<String> levelNames = new Vector<String>();
        NodeList levels = XmlUtils.getChildElementsByName(dimension, "level");
        for (int i = 0; i < levels.getLength(); ++i) {
            Element level = (Element)levels.item(i);
            String name = level.getAttribute("name");
            levelNames.add(name);
        }
        return levelNames;
    }

    public static Element getDimensionOfItem(Element balticItem) {
        Element level = (Element)balticItem.getParentNode();
        if (level == null || !XmlUtils.getName(level).equals("level")) {
            return null;
        }
        Element dimension = (Element)level.getParentNode();
        if (dimension == null || !XmlUtils.getName(dimension).equals("dimension")) {
            return null;
        }
        return dimension;
    }
}

