/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.DomWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BalticSharedQueryAnnotater
implements UpgradePipelineElement {
    private Map<String, Boolean> queryDefinesLevelMap = new HashMap<String, Boolean>();

    private Map<String, LinkedList<Element>> getEligibleFrames(Element layoutList) throws UpgradeException {
        try {
            EligibleFramesExaminer examiner = new EligibleFramesExaminer();
            DomWalker.topDownWalkElements(layoutList, examiner);
            return examiner.getQueriesToEligibleFramesMap();
        }
        catch (XmlException ex) {
            throw new UpgradeException(ex);
        }
    }

    private void loadQueryDefinesLevelMap(Element querySet) throws UpgradeException {
        NodeList biQueryNodes = XmlUtils.getChildElementsByName(querySet, "BIQuery");
        int nbQueries = biQueryNodes.getLength();
        for (int i = 0; i < nbQueries; ++i) {
            Element aBIQuery = (Element)biQueryNodes.item(i);
            String queryName = aBIQuery.getAttribute("name");
            Element cube = BalticQueryFinder.findCube(querySet.getOwnerDocument(), aBIQuery);
            boolean cubeDefinesLevel = false;
            if (cube != null) {
                CubeLevelsExaminer cubeExaminer = new CubeLevelsExaminer();
                try {
                    DomWalker.topDownWalkElements(cube, cubeExaminer);
                    cubeDefinesLevel = cubeExaminer.definesLevels();
                }
                catch (XmlException ex) {
                    throw new UpgradeException(ex);
                }
            }
            Boolean definesGroup = new Boolean(cubeDefinesLevel);
            this.queryDefinesLevelMap.put(queryName, definesGroup);
        }
    }

    private void annotateFrames(Map<String, LinkedList<Element>> queriesToEligibleFramesMap) throws UpgradeException {
        for (LinkedList<Element> frames : queriesToEligibleFramesMap.values()) {
            if (frames.size() <= 1) continue;
            for (Element sharedFrame : frames) {
                sharedFrame.setAttribute(ReportSpecification50._shareResultSet, ReportSpecification50._true);
            }
        }
    }

    private void annotateQueries(Element querySet, Map<String, LinkedList<Element>> eligibleFrames) throws UpgradeException {
        if (eligibleFrames.isEmpty()) {
            return;
        }
        NodeList biQueryNodes = XmlUtils.getChildElementsByName(querySet, "BIQuery");
        int nbQueries = biQueryNodes.getLength();
        for (int i = 0; i < nbQueries; ++i) {
            LinkedList<Element> frames;
            Element aBIQuery = (Element)biQueryNodes.item(i);
            String queryName = aBIQuery.getAttribute("name");
            if (!eligibleFrames.containsKey(queryName) || (frames = eligibleFrames.get(queryName)).size() <= 1) continue;
            aBIQuery.setAttribute(ReportSpecification50._shareResultSet, ReportSpecification50._true);
        }
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (origSpec == null) {
            return origSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(origSpec, "report");
        if (report == null) {
            return origSpec;
        }
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return origSpec;
        }
        Element layoutList = XmlUtils.getFirstChildElementByName(report, "layoutList");
        if (layoutList == null) {
            return origSpec;
        }
        this.loadQueryDefinesLevelMap(querySet);
        Map<String, LinkedList<Element>> eligibleFrames = this.getEligibleFrames(layoutList);
        this.annotateFrames(eligibleFrames);
        this.annotateQueries(querySet, eligibleFrames);
        XmlUtils.writeIntermediateDocument(origSpec, "v4_annotateSharedQueries", upgradeSession.getConfiguration());
        return origSpec;
    }

    private class CubeLevelsExaminer
    implements DomWalker.Examiner {
        private boolean wasExamined = false;
        private boolean definesLevels = false;

        private CubeLevelsExaminer() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element element) throws XmlException {
            this.wasExamined = true;
            String elementName = XmlUtils.getName(element);
            if (elementName.equals("level")) {
                this.definesLevels = true;
                return DomWalker.SearchOrder.stop;
            }
            return DomWalker.SearchOrder.proceed;
        }

        public boolean definesLevels() {
            if (!this.wasExamined) {
                throw new IllegalStateException("The examine method must be called before calling the definesLevels method.");
            }
            return this.definesLevels;
        }
    }

    private class EligibleFramesExaminer
    implements DomWalker.Examiner {
        private Map<String, LinkedList<Element>> queriesToEligibleFramesMap = new HashMap<String, LinkedList<Element>>();
        private boolean wasExamined = false;

        private EligibleFramesExaminer() {
        }

        @Override
        public DomWalker.SearchOrder examine(Element element) throws XmlException {
            LinkedList<Object> frames;
            this.wasExamined = true;
            String elementName = XmlUtils.getName(element);
            if (!elementName.equals("list") && !elementName.equals("repeater")) {
                return DomWalker.SearchOrder.proceed;
            }
            String queryName = element.getAttribute("refQuery");
            if (elementName.equals("repeater") && !element.hasAttribute("refLevel")) {
                if (!BalticSharedQueryAnnotater.this.queryDefinesLevelMap.containsKey(queryName)) {
                    return DomWalker.SearchOrder.proceed;
                }
                Boolean definesGroup = (Boolean)BalticSharedQueryAnnotater.this.queryDefinesLevelMap.get(queryName);
                if (definesGroup.booleanValue()) {
                    return DomWalker.SearchOrder.proceed;
                }
            }
            if (this.queriesToEligibleFramesMap.containsKey(queryName)) {
                frames = this.queriesToEligibleFramesMap.get(queryName);
            } else {
                frames = new LinkedList();
                this.queriesToEligibleFramesMap.put(queryName, frames);
            }
            frames.addLast(element);
            return DomWalker.SearchOrder.proceed;
        }

        public Map<String, LinkedList<Element>> getQueriesToEligibleFramesMap() {
            if (!this.wasExamined) {
                throw new IllegalStateException("The examine method must be called before calling the getQueriesToEligibleFramesMap method.");
            }
            return this.queriesToEligibleFramesMap;
        }
    }
}

