/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification40;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class BeringVariables {
    public static boolean hasVariableReference(Element someReportElement) {
        return someReportElement.hasAttribute(ReportSpecification20._refVariable);
    }

    public static Element getReportVariable(Element variableUser) {
        String variableName = variableUser.getAttribute(ReportSpecification20._refVariable);
        Document doc = variableUser.getOwnerDocument();
        return BeringVariables.getReportVariable(doc, variableName);
    }

    public static Element getReportVariable(Document beringSpec, String variableName) {
        if (beringSpec == null) {
            return null;
        }
        Element report = XmlUtils.getFirstChildElementByName(beringSpec, ReportSpecification20._report);
        Element reportVariables = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._reportVariables);
        if (reportVariables == null) {
            return null;
        }
        Element reportVariable = XmlUtils.getFirstChildElementByNameWithAttributeValue(reportVariables, ReportSpecification20._reportVariable, ReportSpecification20._name, variableName);
        return reportVariable;
    }

    public static NodeList findVariableReferences(Document beringSpec) {
        Element report = XmlUtils.getRoot(beringSpec);
        return XmlUtils.getElementsWithAttribute(report, ReportSpecification20._refVariable);
    }

    public static Element cloneVariable(Element oldVariable) {
        String newName;
        Element variables = (Element)oldVariable.getParentNode();
        String oldName = oldVariable.getAttribute(ReportSpecification20._name);
        int collisionValue = 1;
        boolean collision = true;
        do {
            Element existingVariable;
            StringBuffer buffer = new StringBuffer(oldName);
            if (collisionValue > 1) {
                buffer.append("_");
                buffer.append(collisionValue);
            }
            if ((existingVariable = XmlUtils.getFirstChildElementByNameWithAttributeValue(variables, ReportSpecification20._reportVariable, ReportSpecification20._name, newName = buffer.toString())) == null) {
                collision = false;
            }
            ++collisionValue;
        } while (collision);
        Element newVariable = (Element)oldVariable.cloneNode(true);
        newVariable.setAttribute(ReportSpecification40._name, newName);
        return newVariable;
    }

    public static boolean areVariableDefinitionsSame(Element a, Element b, UpgradeSessionContext context) throws UpgradeException {
        try {
            Element bVariableValueList;
            Element bExpression;
            XmlComparer comparer = context.getXmlComparer();
            String aType = a.getAttribute("type");
            String bType = b.getAttribute("type");
            if (!aType.equals(bType)) {
                return false;
            }
            Element aExpression = XmlUtils.getFirstChildElementByName(a, ReportSpecification20._reportExpression);
            if (!comparer.areNodesSame(aExpression, bExpression = XmlUtils.getFirstChildElementByName(b, ReportSpecification20._reportExpression))) {
                return false;
            }
            Element aVariableValueList = XmlUtils.getFirstChildElementByName(a, "variableValueList");
            return comparer.areNodesSame(aVariableValueList, bVariableValueList = XmlUtils.getFirstChildElementByName(b, "variableValueList"));
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    public static String findExistingVariable(Element variableDefinition, UpgradeSessionContext context) throws UpgradeException {
        Document reportSpec = XmlUtils.getOwnerDoc(variableDefinition);
        if (reportSpec == null) {
            return null;
        }
        Element reportElement = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification20._report);
        if (reportElement == null) {
            return null;
        }
        Element reportVariablesElement = XmlUtils.getFirstChildElementByName(reportElement, ReportSpecification20._reportVariables);
        NodeList variableDefinitions = reportVariablesElement.getElementsByTagName(ReportSpecification20._reportVariable);
        int nbDefinitions = variableDefinitions.getLength();
        for (int definitionNb = 0; definitionNb < nbDefinitions; ++definitionNb) {
            Element definition = (Element)variableDefinitions.item(definitionNb);
            if (!BeringVariables.areVariableDefinitionsSame(variableDefinition, definition, context)) continue;
            String name = definition.getAttribute("name");
            return name;
        }
        return null;
    }
}

