/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.NamespaceContext10x20;
import java.util.LinkedList;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CrosstabInvalidDrillParameterFixup {
    public Document fixup(Document v5Spec, Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String path = "/bering:report/bering:layouts//bering:crosstabFactCell/bering:contents";
            NodeList contentNodes = XmlUtils.selectNodeList(v5Spec, path, NamespaceContext10x20.instance);
            int nbContentNodes = contentNodes.getLength();
            for (int contentNodeIndex = 0; contentNodeIndex < nbContentNodes; ++contentNodeIndex) {
                Element contents = (Element)contentNodes.item(contentNodeIndex);
                LinkedList<Element> dataItemContextNodes = new LinkedList<Element>();
                this.getDataItemContextNodes(contents, dataItemContextNodes);
                for (Element dataItemContextElement : dataItemContextNodes) {
                    Element drillSourceContextElement;
                    Node drillLink;
                    String refDataItem = dataItemContextElement.getAttribute(ReportSpecification20._refDataItem);
                    Element crosstab = BeringQueryFinder.findRefQueryElement(dataItemContextElement);
                    String originalQuery = crosstab.getAttribute("originalRefQuery");
                    Element balticQuery = BalticQueryFinder.findQueryElement(v4Spec, originalQuery);
                    if (balticQuery == null) {
                        RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_QUERY_NOT_FOUND(originalQuery);
                        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)crosstab, 0, msg);
                        continue;
                    }
                    Node drillSourceContext = dataItemContextElement.getParentNode();
                    if (!(drillSourceContext instanceof Element) || !((drillLink = (drillSourceContextElement = (Element)drillSourceContext).getParentNode()) instanceof Element)) continue;
                    Element drillLinkElement = (Element)drillLink;
                    String refKey = BalticQueryFinder.findLevelFirstKeyForItem(v4Spec, balticQuery, refDataItem);
                    if (refKey != null) continue;
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_DEFINED_FOR_DRILL_SOURCE_CONTEXT(refDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote(drillSourceContext, 2, msg);
                    Document doc = drillLinkElement.getOwnerDocument();
                    String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                    Comment comment = doc.createComment(translatedMessage);
                    drillLinkElement.insertBefore(comment, drillSourceContextElement);
                    this.remove(drillSourceContextElement, upgradeSession);
                }
            }
            return v5Spec;
        }
        catch (XPathExpressionException ex) {
            UpgradeException.throwNestedException(ex);
            throw new UpgradeException(ex);
        }
    }

    private void getDataItemContextNodes(Element base, LinkedList<Element> contexts) {
        if (base.hasAttribute(ReportSpecification20._refQuery)) {
            return;
        }
        if (XmlUtils.getName(base).equals(ReportSpecification20._dataItemContext)) {
            contexts.addLast(base);
            return;
        }
        NodeList children = base.getChildNodes();
        int nbChildren = children.getLength();
        for (int childNb = 0; childNb < nbChildren; ++childNb) {
            Node child = children.item(childNb);
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.getDataItemContextNodes(childElement, contexts);
        }
    }

    private void remove(Node node, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            RspecUpgradeMessage deletedMsg = RspecUpgradeMessage.RSU_SPC_XML_NODE_REMOVED_0();
            upgradeSession.getXmlCommentOutTool().commentOutNode(node, deletedMsg);
        }
        catch (XmlException ex) {
            UpgradeException.throwNestedException(ex);
        }
    }
}

