/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CurrencyFormatFixup
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList formats = origSpec.getElementsByTagName("currencyFormat");
        int nbFormats = formats.getLength();
        for (int formatNb = 0; formatNb < nbFormats; ++formatNb) {
            Element format = (Element)formats.item(formatNb);
            if (!this.isDecimalsToBeRemoved(format)) continue;
            Attr attr = format.getAttributeNode("decimalSize");
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DECIMAL_SIZE_REMOVED_FROM_CURRENCY_FORMAT();
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)attr, 2, msg);
            try {
                upgradeSession.getXmlCommentOutTool().commentOutNode((Node)attr, msg);
                continue;
            }
            catch (XmlException e) {
                UpgradeException.throwNestedException(e);
            }
        }
        XmlUtils.writeIntermediateDocument(origSpec, "CurrencyFormatFixup", upgradeSession.getConfiguration());
        return origSpec;
    }

    private boolean isDecimalsToBeRemoved(Element format) {
        if (!format.hasAttribute("decimalSize")) {
            return false;
        }
        Element parent = (Element)format.getParentNode();
        if (parent == null) {
            return false;
        }
        String parentName = XmlUtils.getName(parent);
        if (!parentName.equals("style")) {
            return false;
        }
        if ((parent = (Element)parent.getParentNode()) == null) {
            return false;
        }
        parentName = XmlUtils.getName(parent);
        return parentName.equals("chartBody");
    }
}

