/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.algorithms.AlgorithmException;
import com.cognos.rspecupgrade.internal.algorithms.Filter;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.internal.xml.NodeListIterator;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.SpecificationSemantics;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DanglingDataItemTool {
    private AliasMap aliasMap;

    public DanglingDataItemTool(AliasMap aliasMap) {
        this.aliasMap = aliasMap;
    }

    public boolean isDangling(NameExpression dataItem, Element context) {
        boolean dangling;
        BeringQueryFinder beringQueryFinder = new BeringQueryFinder();
        String queryName = dataItem.getQueryName();
        if (queryName != null) {
            dangling = !beringQueryFinder.isQueryInScope(queryName, context);
        } else {
            String dataItemName = dataItem.getDataItem();
            dangling = this.isDangling(dataItemName, context);
        }
        return dangling;
    }

    public boolean isDangling(String dataItem, Element context) {
        BeringQueryFinder beringQueryFinder = new BeringQueryFinder();
        String queryName = beringQueryFinder.findQueryName(context, dataItem);
        boolean dangling = queryName == null;
        return dangling;
    }

    private String findPromptingBalticQuery(String dataItemName, Element context) {
        if (!this.isInPromptPage(context)) {
            return null;
        }
        String balticQueryName = this.getBalticLayoutQueryName(context);
        if (balticQueryName == null) {
            return null;
        }
        Document reportSpecification = context.getOwnerDocument();
        Element balticQueryElement = BalticQueryFinder.findQueryElement(reportSpecification, balticQueryName);
        if (balticQueryElement == null) {
            return null;
        }
        if (!BalticQueryFinder.queryContainsDataItem(balticQueryElement, dataItemName)) {
            return null;
        }
        return balticQueryName;
    }

    private boolean fixWithBeringQueryName(Element context, String beringQueryName, String danglingDataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element fixLocation = this.findFixLocation(context, beringQueryName, upgradeSession);
        if (fixLocation == null) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM(danglingDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, msg);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
            XmlUtils.insertComment(context, translatedMessage);
            return false;
        }
        this.addQueryReferenceToElement(fixLocation, beringQueryName, upgradeSession);
        return true;
    }

    private LinkedList<Fix> findFixes(Element context, Set<String> beringQueryNames, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LinkedList<Fix> validFixes = new LinkedList<Fix>();
        for (String beringQueryName : beringQueryNames) {
            Element fixLocation = this.findFixLocation(context, beringQueryName, upgradeSession);
            if (fixLocation == null) continue;
            validFixes.add(new Fix(fixLocation, beringQueryName));
        }
        return validFixes;
    }

    private void logDefiningQueries(Element errorLocation, String danglingDataItem, Set<String> beringQueryNames, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (String alternativeQuery : beringQueryNames) {
            RspecUpgradeMessage alternativeQueryMessage = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM_AMBIGUOUS_REFQUERY_ALTERNATIVE(alternativeQuery, danglingDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)errorLocation, 2, alternativeQueryMessage);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(alternativeQueryMessage);
            XmlUtils.insertComment(errorLocation, translatedMessage);
        }
    }

    private void logAmbiguousQueryUsed(Element fixLocation, String beringQueryName, String danglingDataItem, Set<String> beringQueryNames, UpgradeSessionContext upgradeSession) throws UpgradeException {
        RspecUpgradeMessage queryUsedMessage = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM_AMBIGUOUS_REFQUERY_USED(beringQueryName, danglingDataItem);
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)fixLocation, 0, queryUsedMessage);
        String translatedMessage = upgradeSession.getTranslatedMessages().getString(queryUsedMessage);
        XmlUtils.insertComment(fixLocation, translatedMessage);
        beringQueryNames.remove(beringQueryName);
        this.logDefiningQueries(fixLocation, danglingDataItem, beringQueryNames, upgradeSession);
    }

    private boolean fixWithBeringQueryNames(Element context, Set<String> beringQueryNames, String danglingDataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        LinkedList<Fix> validFixes = this.findFixes(context, beringQueryNames, upgradeSession);
        Fix fix = null;
        if (!validFixes.isEmpty()) {
            fix = validFixes.getFirst();
            this.addQueryReferenceToElement(fix.fixLocation, fix.beringQueryName, upgradeSession);
        }
        if (beringQueryNames.size() == 0) {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM(danglingDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, msg);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
            XmlUtils.insertComment(context, translatedMessage);
        } else if (beringQueryNames.size() == 1) {
            if (fix == null) {
                String beringQueryName = beringQueryNames.iterator().next();
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM_REFQUERY_LOCATION_NOT_FOUND(beringQueryName, danglingDataItem);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, msg);
                String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
                XmlUtils.insertComment(context, translatedMessage);
            }
        } else if (fix != null) {
            this.logAmbiguousQueryUsed(fix.fixLocation, fix.beringQueryName, danglingDataItem, beringQueryNames, upgradeSession);
        } else {
            RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM(danglingDataItem);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, msg);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(msg);
            XmlUtils.insertComment(context, translatedMessage);
            this.logDefiningQueries(context, danglingDataItem, beringQueryNames, upgradeSession);
        }
        return fix != null;
    }

    private Set<String> mapBalticQueriesToBeringQueries(Set<String> balticQueries) {
        TreeSet<String> beringQueries = new TreeSet<String>();
        for (String balticQueryName : balticQueries) {
            String beringQueryName = this.aliasMap.getNewQueryName(balticQueryName);
            beringQueries.add(beringQueryName);
        }
        return beringQueries;
    }

    private boolean fixWithBalticQueryNames(Element context, Set<String> balticQueryNames, String danglingDataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Set<String> beringQueryNames = this.mapBalticQueriesToBeringQueries(balticQueryNames);
        boolean result = this.fixWithBeringQueryNames(context, beringQueryNames, danglingDataItem, upgradeSession);
        return result;
    }

    private Set<String> findBalticQueryNames(String dataItemName, Element context) {
        String promptQueryName;
        Set<String> balticQueryNamesForPage = this.findBalticQueryNamesInCurrentPageForDataItem(context, dataItemName);
        if (balticQueryNamesForPage.size() != 1 && (promptQueryName = this.findPromptingBalticQuery(dataItemName, context)) != null) {
            HashSet<String> result = new HashSet<String>(1);
            result.add(promptQueryName);
            return result;
        }
        return balticQueryNamesForPage;
    }

    public boolean fix(String dataItemName, Element context, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Set<String> balticQueryNames = this.findBalticQueryNames(dataItemName, context);
        boolean result = this.fixWithBalticQueryNames(context, balticQueryNames, dataItemName, upgradeSession);
        return result;
    }

    public boolean fix(NameExpression beringDataItem, Element context, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String beringQueryName = beringDataItem.getQueryName();
        if (beringQueryName != null) {
            Locale msgLocale = upgradeSession.getTranslatedMessages().getLocale();
            String danglingDataItem = beringDataItem.toString(msgLocale);
            return this.fixWithBeringQueryName(context, beringQueryName, danglingDataItem, upgradeSession);
        }
        String dataItemName = beringDataItem.getDataItem();
        return this.fix(dataItemName, context, upgradeSession);
    }

    private boolean isInPromptPage(Element layoutElement) {
        Element promptPagesElement = XmlUtils.getAncestorElement(layoutElement, ReportSpecification20._promptPages);
        return promptPagesElement != null;
    }

    private String getBalticLayoutQueryName(Element beringElement) {
        Element layoutElement = XmlUtils.getAncestorElement(beringElement, ReportSpecification20._layout);
        if (layoutElement.hasAttribute("layoutRefQuery")) {
            return layoutElement.getAttribute("layoutRefQuery");
        }
        return null;
    }

    public Element findEmptyQueryReference(Element context) {
        while (context != null) {
            String elemName;
            if (!context.hasAttribute(ReportSpecification20._refQuery) && (ReportSpecification20._selectValue.equals(elemName = XmlUtils.getName(context)) || ReportSpecification20._selectWithSearch.equals(elemName) || ReportSpecification20._selectWithTree.equals(elemName) || ReportSpecification20._page.equals(elemName))) {
                return context;
            }
            context = XmlUtils.getParentElement(context);
        }
        return context;
    }

    public Element findFixLocation(Element context, String beringQueryName, UpgradeSessionContext upgradeSession) throws UpgradeException {
        while (context != null) {
            Element fixLocation = this.findEmptyQueryReference(context);
            if (fixLocation == null) {
                return null;
            }
            if (this.isSafe(fixLocation, beringQueryName, true, upgradeSession)) {
                return fixLocation;
            }
            context = XmlUtils.getParentElement(fixLocation);
        }
        return null;
    }

    private void setRefQueryAttribute(Element layoutElement, String beringQueryName) {
        layoutElement.setAttribute(ReportSpecification20._refQuery, beringQueryName);
        if (null == XmlUtils.getFirstChildElementByName(layoutElement, ReportSpecification20._propertyList)) {
            Document beringDoc = layoutElement.getOwnerDocument();
            Element propertyListElement = beringDoc.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._propertyList);
            layoutElement.appendChild(propertyListElement);
        }
    }

    private LinkedList<Element> filterForMasterDetail(NodeList refQueryElements) throws UpgradeException {
        try {
            LinkedList<Element> result = new LinkedList<Element>();
            Filter<Element> filterAlgorithm = new Filter<Element>();
            class MasterDetailFilterCondition
            implements Filter.ConditionTest<Element> {
                MasterDetailFilterCondition() {
                }

                @Override
                public boolean evaluate(Element refQueryElement) throws AlgorithmException {
                    Element masterDetail = XmlUtils.getFirstChildElementByName(refQueryElement, ReportSpecification20._masterDetailLinks);
                    return masterDetail != null;
                }
            }
            filterAlgorithm.filter(new NodeListIterator(refQueryElements), new MasterDetailFilterCondition(), result);
            LinkedList<Element> linkedList = result;
            return linkedList;
        }
        catch (AlgorithmException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private LinkedList<Element> filterRefQuery(final String queryName, LinkedList<Element> queryElements) throws UpgradeException {
        try {
            LinkedList<Element> result = new LinkedList<Element>();
            Filter<Element> filterAlgorithm = new Filter<Element>();
            class QueryFilterCondition
            implements Filter.ConditionTest<Element> {
                QueryFilterCondition() {
                }

                @Override
                public boolean evaluate(Element anObject) throws AlgorithmException {
                    Element refQueryElement = anObject;
                    String attrValue = refQueryElement.getAttribute(ReportSpecification20._refQuery);
                    return !queryName.equals(attrValue);
                }
            }
            filterAlgorithm.filter(queryElements, new QueryFilterCondition(), result);
            LinkedList<Element> linkedList = result;
            return linkedList;
        }
        catch (AlgorithmException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private LinkedList<Element> filterListQueries(LinkedList<Element> queryElements) throws UpgradeException {
        try {
            LinkedList<Element> result = new LinkedList<Element>();
            Filter<Element> filterAlgorithm = new Filter<Element>();
            class ListFilterCondition
            implements Filter.ConditionTest<Element> {
                ListFilterCondition() {
                }

                @Override
                public boolean evaluate(Element refQueryElement) throws AlgorithmException {
                    return !SpecificationSemantics.isListQuery(refQueryElement);
                }
            }
            filterAlgorithm.filter(queryElements, new ListFilterCondition(), result);
            LinkedList<Element> linkedList = result;
            return linkedList;
        }
        catch (AlgorithmException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private void logNonListDetail(Element layoutElement, String beringQueryName, String outerQueryName, LinkedList<Element> nonListQueries, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (Element detailChild : nonListQueries) {
            String detailQueryName = detailChild.getAttribute(ReportSpecification20._refQuery);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM_MASTER_DETAIL_NON_LIST(beringQueryName, outerQueryName, detailQueryName, XmlUtils.getName(detailChild));
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutElement, 2, message);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(message);
            XmlUtils.insertComment(layoutElement, translatedMessage);
        }
    }

    private void logDifferentDetailQueries(Element layoutElement, String beringQueryName, String outerQueryName, LinkedList<Element> differentQueries, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (Element detailChild : differentQueries) {
            String detailQueryName = detailChild.getAttribute(ReportSpecification20._refQuery);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DANGLING_DATA_ITEM_MASTER_DETAIL(beringQueryName, outerQueryName, detailQueryName);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutElement, 2, message);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(message);
            XmlUtils.insertComment(layoutElement, translatedMessage);
        }
    }

    private boolean isMasterDetailSafe(Element layoutElement, String beringQueryName, boolean logDiagnostics, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element outerQuery = BeringQueryFinder.findRefQueryElement(layoutElement);
        if (outerQuery == null) {
            return true;
        }
        String outerQueryName = outerQuery.getAttribute(ReportSpecification20._refQuery);
        NodeList childQueryLayouts = BeringQueryFinder.findChildQueries(layoutElement);
        LinkedList<Element> childDetails = this.filterForMasterDetail(childQueryLayouts);
        if (childDetails.isEmpty()) {
            return true;
        }
        LinkedList<Element> differentQueries = this.filterRefQuery(beringQueryName, childDetails);
        if (!differentQueries.isEmpty()) {
            if (logDiagnostics) {
                this.logDifferentDetailQueries(layoutElement, beringQueryName, outerQueryName, differentQueries, upgradeSession);
            }
            return false;
        }
        LinkedList<Element> nonListQueries = this.filterListQueries(childDetails);
        if (!nonListQueries.isEmpty()) {
            if (logDiagnostics) {
                this.logNonListDetail(layoutElement, beringQueryName, outerQueryName, nonListQueries, upgradeSession);
            }
            return false;
        }
        return true;
    }

    boolean isSafe(Element layoutElement, String beringQueryName, boolean logDiagnostics, UpgradeSessionContext upgradeSession) throws UpgradeException {
        return this.isMasterDetailSafe(layoutElement, beringQueryName, logDiagnostics, upgradeSession);
    }

    private void makeMasterDetailSafe(Element layoutElement, String beringQueryName, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element outerQuery = BeringQueryFinder.findRefQueryElement(layoutElement);
        if (outerQuery == null) {
            return;
        }
        NodeList childQueryLayouts = BeringQueryFinder.findChildQueries(layoutElement);
        LinkedList<Element> childDetails = this.filterForMasterDetail(childQueryLayouts);
        if (childDetails.isEmpty()) {
            return;
        }
        Element childRefQuery = childDetails.getFirst();
        Element childMasterDetail = XmlUtils.getFirstChildElementByName(childRefQuery, ReportSpecification20._masterDetailLinks);
        layoutElement.appendChild(childMasterDetail);
        for (Element detailRefQueryElement : childDetails) {
            XmlUtils.removeChild(detailRefQueryElement, ReportSpecification20._masterDetailLinks);
        }
    }

    private void addQueryReferenceToElement(Element layoutElement, String beringQueryName, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (layoutElement == null) {
            throw new UpgradeException("Internal error: layoutElement may not be null");
        }
        if (beringQueryName == null) {
            throw new UpgradeException("Internal error: beringQueryName may not be null");
        }
        if (layoutElement.hasAttribute(ReportSpecification20._refQuery)) {
            throw new UpgradeException("Internal error: refQuery may not exist");
        }
        this.makeMasterDetailSafe(layoutElement, beringQueryName, upgradeSession);
        this.setRefQueryAttribute(layoutElement, beringQueryName);
    }

    private Set<String> findBalticQueryNamesInCurrentPageForDataItem(Element context, String dataItemName) {
        Document doc = context.getOwnerDocument();
        Element pageElem = XmlUtils.getAncestorOrSelfElement(context, ReportSpecification20._page);
        if (pageElem == null) {
            return new HashSet<String>();
        }
        Set<String> balticQueryNamesOnPage = BeringQueryFinder.findReferencedOriginalQueryNames(pageElem);
        Set<String> queryNames = this.filterQueriesForDataItem(doc, balticQueryNamesOnPage, dataItemName);
        return queryNames;
    }

    private Set<String> filterQueriesForDataItem(Document augmented_v5, Set<String> balticQueryNames, String dataItemName) {
        HashSet<String> queryNames = new HashSet<String>(balticQueryNames.size());
        Element report = XmlUtils.getFirstChildElementByName(augmented_v5, "report");
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return queryNames;
        }
        Element biQuery = XmlUtils.getFirstChildElementByName(querySet, "BIQuery");
        while (biQuery != null) {
            String possibleQueryName = biQuery.getAttribute("name");
            if (balticQueryNames.contains(possibleQueryName) && BalticQueryFinder.queryContainsDataItem(biQuery, dataItemName)) {
                queryNames.add(possibleQueryName);
            }
            biQuery = XmlUtils.getNextSiblingElement(biQuery);
        }
        return queryNames;
    }

    private class Fix {
        Element fixLocation;
        String beringQueryName;

        Fix(Element location, String queryName) {
            this.fixLocation = location;
            this.beringQueryName = queryName;
        }
    }
}

