/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.AliasMap;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.DanglingDataItemTool;
import java.io.StringReader;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DanglingReferenceDetector {
    private DanglingDataItemTool danglingTool;
    private AliasMap aliasMap;
    private Locale expressionLocale;

    public DanglingReferenceDetector(Locale expressionLocale) {
        this.expressionLocale = expressionLocale;
        this.aliasMap = null;
    }

    public Document fixup(AliasMap aliasMap, Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.aliasMap = aliasMap;
        this.danglingTool = new DanglingDataItemTool(this.aliasMap);
        this.fixupRefDataItems(v5, upgradeSession);
        this.fixupVariables(v5, upgradeSession);
        this.fixupReportExpressions(v5, upgradeSession);
        return v5;
    }

    private void fixupReportExpressions(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5, ReportSpecification20._report);
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts != null) {
            this.fixupReportExpressions(layouts, upgradeSession);
        }
    }

    private void fixupReportExpressions(Element v5Element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String elemName = XmlUtils.getName(v5Element);
        if (elemName.equals(ReportSpecification20._reportExpression)) {
            this.fixupReportExpressionInContext(v5Element, v5Element, upgradeSession);
        }
        for (Node child = v5Element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.fixupReportExpressions(childElement, upgradeSession);
        }
    }

    private void fixupReportExpressionInContext(Element reportExpression, Element context, UpgradeSessionContext upgradeSession) throws UpgradeException {
        IExpression parseTree;
        String expression = XmlUtils.getText(reportExpression);
        StringReader reader = new StringReader(expression);
        try {
            CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
            parseTree = parser.start();
        }
        catch (CrxParserException ex) {
            UpgradeException.throwNestedException(ex);
            throw new UpgradeException(ex);
        }
        Set<NameExpression> refDataItems = GetNames.getNames(parseTree);
        if (!refDataItems.isEmpty()) {
            for (NameExpression dataItem : refDataItems) {
                if (!this.danglingTool.isDangling(dataItem, context)) continue;
                this.danglingTool.fix(dataItem, context, upgradeSession);
            }
        }
    }

    private void fixupVariables(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5, ReportSpecification20._report);
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts != null) {
            this.fixupVariables(layouts, upgradeSession);
        }
    }

    private void fixupVariables(Element v5Element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (v5Element.hasAttribute(ReportSpecification20._refVariable)) {
            String variableName = v5Element.getAttribute(ReportSpecification20._refVariable);
            Document v5 = v5Element.getOwnerDocument();
            Element report = XmlUtils.getFirstChildElementByName(v5, ReportSpecification20._report);
            Element reportVariables = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._reportVariables);
            if (reportVariables == null) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_VARIABLE_NOT_DEFINED(variableName);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5Element, 0, msg);
                return;
            }
            Element reportVariable = XmlUtils.getFirstChildElementByNameWithAttributeValue(reportVariables, ReportSpecification20._reportVariable, ReportSpecification20._name, variableName);
            if (reportVariable == null) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_VARIABLE_NOT_DEFINED(variableName);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5Element, 0, msg);
                return;
            }
            Element reportExpression = XmlUtils.getFirstChildElementByName(reportVariable, ReportSpecification20._reportExpression);
            if (reportExpression != null) {
                this.fixupReportExpressionInContext(reportExpression, v5Element, upgradeSession);
            }
        }
        for (Node child = v5Element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.fixupVariables(childElement, upgradeSession);
        }
    }

    private void fixupRefDataItems(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5, ReportSpecification20._report);
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts != null) {
            this.fixupRefDataItems(layouts, upgradeSession);
        }
    }

    private void fixupRefDataItems(Element v5Element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (v5Element.hasAttribute(ReportSpecification20._refDataItem)) {
            this.fixupSingleRefDataItem(v5Element, upgradeSession);
        }
        for (Node child = v5Element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.fixupRefDataItems(childElement, upgradeSession);
        }
    }

    private void fixupSingleRefDataItem(Element v5Element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String dataItemName = v5Element.getAttribute(ReportSpecification20._refDataItem);
        if (this.danglingTool.isDangling(dataItemName, v5Element)) {
            this.danglingTool.fix(dataItemName, v5Element, upgradeSession);
        }
    }
}

