/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParser;
import com.cognos.rspecupgrade.internal.expressionparser.cqe.CqeParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlComparer;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline.tools.ExpressionLocale;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class DuplicateDataItemRemover
implements UpgradePipelineElement {
    protected DuplicateDataItemRemover() {
    }

    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        origSpec = this.doUpgrade(origSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(origSpec, "v5_DuplicateDataRemover", upgradeSession.getConfiguration());
        return origSpec;
    }

    private Document doUpgrade(Document beringReportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (beringReportSpec == null) {
            return beringReportSpec;
        }
        Element report = XmlUtils.getFirstChildElementByName(beringReportSpec, ReportSpecification20._report);
        if (report == null) {
            return beringReportSpec;
        }
        Element queries = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._queries);
        if (queries == null) {
            return beringReportSpec;
        }
        Locale expressionLocale = ExpressionLocale.getExpressionLocale(beringReportSpec, upgradeSession);
        NodeList queryNodes = XmlUtils.getChildElementsByName(queries, ReportSpecification20._query);
        int nbQueries = queryNodes.getLength();
        for (int i = 0; i < nbQueries; ++i) {
            Element query = (Element)queryNodes.item(i);
            this.checkQuery(query, expressionLocale, upgradeSession);
        }
        return beringReportSpec;
    }

    private void checkQuery(Element query, Locale expressionLocale, UpgradeSessionContext context) throws UpgradeException {
        Element selection = XmlUtils.getFirstChildElementByName(query, ReportSpecification20._selection);
        if (selection == null) {
            return;
        }
        HashMap<String, Element> dataItems = new HashMap<String, Element>();
        NodeList dataItemList = XmlUtils.getChildElementsByName(selection, ReportSpecification20._dataItem);
        int nbDataItems = dataItemList.getLength();
        for (int i = 0; i < nbDataItems; ++i) {
            Element newDataItem = (Element)dataItemList.item(i);
            String name = newDataItem.getAttribute(ReportSpecification20._name);
            if (!dataItems.containsKey(name)) {
                dataItems.put(name, newDataItem);
                continue;
            }
            Element previousDeclaration = (Element)dataItems.get(name);
            boolean sameDataItem = this.areDataItemsSame(newDataItem, previousDeclaration, expressionLocale, context);
            if (sameDataItem) {
                this.removeDuplicateDataItem(newDataItem, query, context);
                continue;
            }
            this.removeConflictingDataItem(newDataItem, query, context);
        }
    }

    private boolean areDataItemsSame(Element a, Element b, Locale expressionLocale, UpgradeSessionContext context) throws UpgradeException {
        try {
            IExpression bExpression;
            if (a == b) {
                return true;
            }
            XmlComparer comparer = context.getXmlComparer();
            if (!comparer.areAttributesSame(a, b)) {
                return false;
            }
            IExpression aExpression = this.getExpression(a, expressionLocale, context);
            return aExpression.equals(bExpression = this.getExpression(b, expressionLocale, context));
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException(e);
        }
    }

    private IExpression getExpression(Element dataItem, Locale expressionLocale, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element expression = XmlUtils.getFirstChildElementByName(dataItem, ReportSpecification20._expression);
        String text = XmlUtils.getText(expression);
        try {
            StringReader reader = new StringReader(text);
            CqeParser parser = new CqeParser(reader, expressionLocale);
            IExpression parseTree = parser.start();
            parseTree = parseTree.optimize();
            return parseTree;
        }
        catch (CqeParserException e) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CQE_PARSER_ERROR_2(text, e.getLocalizedMessage());
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)dataItem, 0, message);
            String translatedMessage = upgradeSession.getTranslatedMessages().getString(message);
            throw new UpgradeException(translatedMessage, e);
        }
    }

    protected abstract void removeDuplicateDataItem(Element var1, Element var2, UpgradeSessionContext var3) throws UpgradeException;

    private void removeConflictingDataItem(Element dataItem, Element query, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String queryName = query.getAttribute(ReportSpecification20._name);
            String name = dataItem.getAttribute(ReportSpecification20._name);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONFLICTING_DATA_ITEM_REMOVED(name, queryName);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)dataItem, 0, message);
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)dataItem, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }
}

