/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DuplicateNameDetector {
    public Document fixup(Document v4, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v4, "report");
        this.fixupQuerySet(report, upgradeSession);
        this.fixupVariableList(report, upgradeSession);
        this.fixupLayoutList(report, upgradeSession);
        return v4;
    }

    private void fixupQuerySet(Element report, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element querySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        if (querySet == null) {
            return;
        }
        NodeList queryNodes = XmlUtils.getChildElementsByName(querySet, "BIQuery");
        if (queryNodes == null) {
            return;
        }
        int nQueries = queryNodes.getLength();
        HashSet<String> queryNames = new HashSet<String>(nQueries);
        for (int i = nQueries - 1; i >= 0; --i) {
            Element query = (Element)queryNodes.item(i);
            String queryName = query.getAttribute("name");
            if (queryNames.contains(queryName)) {
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DUPLICATE_BALTIC_QUERY_REMOVED(queryName);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)query, 2, msg);
                try {
                    upgradeSession.getXmlCommentOutTool().commentOutNode((Node)query, msg);
                }
                catch (XmlException e) {
                    UpgradeException.throwNestedException(e);
                }
                continue;
            }
            queryNames.add(queryName);
            this.fixupNames(query, "dimension", false, true, upgradeSession);
            this.fixupNames(query, "level", false, true, upgradeSession);
            this.fixupTabularModels(query, upgradeSession);
        }
    }

    private void fixupTabularModels(Element query, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList tabularModelList = query.getElementsByTagName("tabularModel");
        if (tabularModelList == null) {
            return;
        }
        int nNodes = tabularModelList.getLength();
        for (int i = 0; i < nNodes; ++i) {
            Element tabularModelElement = (Element)tabularModelList.item(i);
            this.fixupNames(tabularModelElement, "dataItem", true, true, upgradeSession);
        }
    }

    private void fixupLayoutList(Element reportElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element layoutListElement = XmlUtils.getFirstChildElementByName(reportElement, "layoutList");
        if (layoutListElement != null) {
            this.fixupPageSets(layoutListElement, upgradeSession);
        }
    }

    private void fixupPageSets(Element layoutListElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList pageSetNodes = layoutListElement.getElementsByTagName("pageSet");
        if (pageSetNodes == null) {
            return;
        }
        int nPages = pageSetNodes.getLength();
        for (int i = 0; i < nPages; ++i) {
            Element pageSetElement = (Element)pageSetNodes.item(i);
            this.fixupNames(pageSetElement, "page", false, true, upgradeSession);
        }
    }

    void fixupVariableList(Element report, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.fixupNames(report, "variable", false, false, upgradeSession);
    }

    void renameDuplicate(Element theElement, Set<String> elementNames, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String nameAttributeValue = theElement.getAttribute("name");
        String newName = this.makeNewName(elementNames, nameAttributeValue);
        theElement.setAttribute("name", newName);
        elementNames.add(newName);
        Element parentElement = XmlUtils.getParentElement(theElement);
        String parentElementTagName = XmlUtils.getName(parentElement);
        String elementTagName = XmlUtils.getName(theElement);
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DUPLICATE_ELEMENT_RENAMED("name", elementTagName, parentElementTagName, nameAttributeValue, newName);
        upgradeSession.getUpgradeNotes().addUpgradeNote(theElement, 0, message, true);
    }

    void removeDuplicate(Element theElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        try {
            String nameAttributeValue = theElement.getAttribute("name");
            Element parentElement = XmlUtils.getParentElement(theElement);
            String parentElementTagName = XmlUtils.getName(parentElement);
            String elementTagName = XmlUtils.getName(theElement);
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DUPLICATE_ELEMENT_REMOVED("name", elementTagName, parentElementTagName, nameAttributeValue);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)theElement, 0, message);
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)theElement, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void fixupNames(Element parentElement, String elementTagName, boolean childNodesOnly, boolean rename, UpgradeSessionContext upgradeSession) throws UpgradeException {
        HashSet<String> elementNames = new HashSet<String>();
        NodeList nodeList = null;
        nodeList = childNodesOnly ? XmlUtils.getChildElementsByName(parentElement, elementTagName) : parentElement.getElementsByTagName(elementTagName);
        if (nodeList == null) {
            return;
        }
        int nNodes = nodeList.getLength();
        for (int i = 0; i < nNodes; ++i) {
            Element theElement = (Element)nodeList.item(i);
            String nameAttributeValue = theElement.getAttribute("name");
            if (nameAttributeValue.length() <= 0) continue;
            if (elementNames.contains(nameAttributeValue)) {
                if (rename) {
                    this.renameDuplicate(theElement, elementNames, upgradeSession);
                    continue;
                }
                this.removeDuplicate(theElement, upgradeSession);
                continue;
            }
            elementNames.add(nameAttributeValue);
        }
    }

    private String makeNewName(Set<String> nameSet, String oldName) {
        StringBuffer newName = null;
        int i = 1;
        do {
            newName = new StringBuffer(oldName);
            newName.append("_");
            newName.append(++i);
        } while (nameSet.contains(newName.toString()));
        return newName.toString();
    }
}

