/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.xml.PathWalker;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgraders.UpgradePipelineElement;
import java.util.HashSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DuplicateRefVariableValueFixer
implements UpgradePipelineElement {
    @Override
    public Document upgrade(Document origSpec, UpgradeSessionContext context) throws UpgradeException {
        Element layouts;
        try {
            layouts = PathWalker.getC8LayoutsElement(origSpec);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
            throw new UpgradeException();
        }
        if (layouts == null) {
            return origSpec;
        }
        this.check(layouts, context);
        return origSpec;
    }

    private void check(Element element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        if (element.hasAttribute(ReportSpecification20._refVariable)) {
            this.checkChildren(element, upgradeSession);
        }
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            this.check(childElem, upgradeSession);
        }
    }

    private void checkChildren(Element element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Node child = element.getFirstChild();
        if (child == null) {
            return;
        }
        HashSet<String> previousValues = new HashSet<String>();
        while (child != null) {
            Element childElem;
            Node nextChild = child.getNextSibling();
            if (child instanceof Element && (childElem = (Element)child).hasAttribute(ReportSpecification20._refVariableValue)) {
                String value = childElem.getAttribute(ReportSpecification20._refVariableValue);
                if (!previousValues.contains(value)) {
                    previousValues.add(value);
                } else {
                    RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_SPC_DUPLICATE_REFVARIABLEVALUE(value);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)childElem, 1, msg);
                    try {
                        upgradeSession.getXmlCommentOutTool().commentOutNode((Node)childElem, msg);
                    }
                    catch (XmlException e) {
                        UpgradeException.throwNestedException(e);
                    }
                }
            }
            child = nextChild;
        }
    }
}

