/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.parsetree.BooleanValue;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.queryfinder.QueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.ReportVariableHelper;
import java.util.Hashtable;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExpressionQueryFixer {
    public IExpression fixQueries(IExpression parseTree, Element context, QueryFinder queryFinder, String expression, boolean flagDanglingDataItems, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Set<NameExpression> names = GetNames.getNames(parseTree);
        int nbNames = names.size();
        if (nbNames == 0) {
            return parseTree;
        }
        Hashtable<NameExpression, NameExpression> nameReplacements = new Hashtable<NameExpression, NameExpression>(nbNames);
        for (NameExpression name : names) {
            if (name.getQueryName() != null) continue;
            String dataItem = name.getDataItem();
            String queryName = queryFinder.findQueryName(context, dataItem);
            if (queryName == null) {
                if (!flagDanglingDataItems) continue;
                RspecUpgradeMessage msg = RspecUpgradeMessage.RSU_UPG_QUERY_NOT_FOUND_FOR_DATAITEM_EXPRESSION(dataItem, expression);
                if (ReportVariableHelper.hasVariableReference(context)) {
                    Element reportVariable = ReportVariableHelper.getReportVariable(context);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)reportVariable, 0, msg);
                    continue;
                }
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, msg);
                continue;
            }
            NameExpression newName = new NameExpression();
            newName.add(queryName);
            newName.add(dataItem);
            nameReplacements.put(name, newName);
        }
        if (!nameReplacements.isEmpty()) {
            BooleanValue changed = new BooleanValue(false);
            parseTree = parseTree.replace(nameReplacements, changed);
            if (!changed.get()) {
                throw new UpgradeException("Internal error name not replaced.");
            }
        }
        return parseTree;
    }
}

