/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.xml.XmlException;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BeringVariables;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InvalidVariableReferenceDetector {
    public Document detectAndFix(Document beringSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList variableReferences = BeringVariables.findVariableReferences(beringSpec);
        int nbNodes = variableReferences.getLength();
        for (int i = 0; i < nbNodes; ++i) {
            String variableName;
            Element variableElement;
            Element variableUser = (Element)variableReferences.item(i);
            boolean bInvalidVariable = false;
            if (upgradeSession.getUpgradeNotes().containsErrorMessages(variableUser)) {
                bInvalidVariable = true;
            }
            if ((variableElement = BeringVariables.getReportVariable(beringSpec, variableName = variableUser.getAttribute(ReportSpecification20._refVariable))) == null) {
                bInvalidVariable = true;
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_VARIABLE_NOT_DEFINED(variableName);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)variableUser, 0, message);
            } else if (upgradeSession.getUpgradeNotes().containsErrorMessages(variableElement)) {
                bInvalidVariable = true;
            }
            boolean bFixed = false;
            if (bInvalidVariable) {
                bFixed = this.fixVariableReference(variableUser, upgradeSession);
            }
            if (!bFixed || variableUser == null) continue;
            upgradeSession.getUpgradeNotes().downgradeErrorsToWarnings(variableUser);
        }
        return beringSpec;
    }

    private boolean fixVariableReference(Element refElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String elementName = XmlUtils.getName(refElement);
        if (elementName.equals(ReportSpecification20._conditionalStyleCases)) {
            return this.fixConditionalStyle(refElement, upgradeSession);
        }
        if (elementName.equals(ReportSpecification20._conditionalLayouts)) {
            return this.fixConditionalLayouts(refElement, upgradeSession);
        }
        return false;
    }

    private boolean fixConditionalStyle(Element conditionalStyleCasesElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String variableName = conditionalStyleCasesElement.getAttribute(ReportSpecification20._refVariable);
        Element conditionalStylesElement = (Element)conditionalStyleCasesElement.getParentNode();
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONAL_STYLE_REMOVED(variableName);
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalStylesElement, 1, message);
        try {
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalStylesElement, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return true;
    }

    private boolean fixConditionalLayouts(Element conditionalLayoutsElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String variableName = conditionalLayoutsElement.getAttribute(ReportSpecification20._refVariable);
        RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CONDITIONAL_LAYOUTS_REMOVED(variableName);
        upgradeSession.getUpgradeNotes().addUpgradeNote((Node)conditionalLayoutsElement, 1, message);
        try {
            upgradeSession.getXmlCommentOutTool().commentOutNode((Node)conditionalLayoutsElement, message);
        }
        catch (XmlException e) {
            UpgradeException.throwNestedException(e);
        }
        return true;
    }
}

