/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LayoutComponentRefFixups {
    public Document layoutComponentRefFixups(Document v4Spec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList layoutComponentReferences = v4Spec.getElementsByTagName("layoutComponentRef");
        int nbReferences = layoutComponentReferences.getLength();
        for (int referenceNb = 0; referenceNb < nbReferences; ++referenceNb) {
            Element layoutComponentRef = (Element)layoutComponentReferences.item(referenceNb);
            Element referencedElement = this.getReferencedElement(layoutComponentRef);
            if (referencedElement == null) continue;
            this.layoutComponentRefFixupsPageRefQuery(layoutComponentRef, referencedElement, upgradeSession);
        }
        return v4Spec;
    }

    private void layoutComponentRefFixupsPageRefQuery(Element layoutComponentRef, Element referencedElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Set<Attr> refItems = this.findAttribute(referencedElement, "refItem");
        for (Attr refItem : refItems) {
            this.fixupRefItem(refItem, layoutComponentRef, referencedElement, upgradeSession);
        }
    }

    private void fixupRefItem(Attr refItem, Element layoutComponentRef, Element referencedElement, UpgradeSessionContext upgradeSession) throws UpgradeException {
        BalticQueryFinder queryFinder = new BalticQueryFinder();
        String refItemValue = refItem.getValue();
        String queryName = this.findRefQueryInScope(refItem, referencedElement);
        if (queryName != null) {
            return;
        }
        queryName = queryFinder.findQueryName(layoutComponentRef, refItemValue);
        if (queryName != null) {
            return;
        }
        Element page = XmlUtils.getAncestorOrSelfElement(layoutComponentRef, "page");
        if (page == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_SCOPE(refItemValue);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 0, message);
            return;
        }
        if (page.hasAttribute("refQuery")) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_SCOPE(refItemValue);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 0, message);
            return;
        }
        queryName = null;
        Document v4Spec = refItem.getOwnerDocument();
        NodeList queries = v4Spec.getElementsByTagName("BIQuery");
        int nbQueries = queries.getLength();
        for (int queryNb = 0; queryNb < nbQueries; ++queryNb) {
            Element biQuery = (Element)queries.item(queryNb);
            if (!BalticQueryFinder.queryContainsDataItem(biQuery, refItemValue)) continue;
            if (queryName != null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_SCOPE(refItemValue);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 0, message);
                return;
            }
            queryName = biQuery.getAttribute("name");
        }
        if (queryName == null) {
            RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_DATA_ITEM_NOT_IN_SCOPE(refItemValue);
            upgradeSession.getUpgradeNotes().addUpgradeNote((Node)layoutComponentRef, 0, message);
            return;
        }
        page.setAttribute("refQuery", queryName);
    }

    Set<Attr> findAttribute(Element element, String name) {
        HashSet<Attr> result = new HashSet<Attr>();
        this.findAttribute(element, name, result);
        return result;
    }

    void findAttribute(Element element, String name, Set<Attr> attributes) {
        if (element.hasAttribute(name)) {
            Attr attribute = element.getAttributeNode(name);
            attributes.add(attribute);
        }
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.findAttribute(childElement, name, attributes);
        }
    }

    private String findRefQueryInScope(Attr refItem, Element scope) {
        String dataItemName = refItem.getValue();
        Document v4Spec = refItem.getOwnerDocument();
        Element elem = refItem.getOwnerElement();
        while (elem != null) {
            String queryName;
            Element query;
            if (elem.hasAttribute("refQuery") && BalticQueryFinder.queryContainsDataItem(query = BalticQueryFinder.findQueryElement(v4Spec, queryName = elem.getAttribute("refQuery")), dataItemName)) {
                return queryName;
            }
            if (elem == scope) {
                elem = null;
                continue;
            }
            elem = (Element)elem.getParentNode();
        }
        return null;
    }

    private Element getReferencedElement(Element layoutComponentRef) {
        if (!layoutComponentRef.hasAttribute("href")) {
            return null;
        }
        String href = layoutComponentRef.getAttribute("href");
        if (href.length() < 2) {
            return null;
        }
        if (href.charAt(0) != '#') {
            return null;
        }
        String ref = href.substring(1);
        Element referencedElement = XmlUtils.getElementWithId(layoutComponentRef.getOwnerDocument(), ref);
        return referencedElement;
    }
}

