/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20;

import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParser;
import com.cognos.rspecupgrade.internal.expressionparser.crx.CrxParserException;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.IExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.NameExpression;
import com.cognos.rspecupgrade.internal.expressionparser.parsetree.utils.GetNames;
import com.cognos.rspecupgrade.internal.io.NodeListListImpl;
import com.cognos.rspecupgrade.internal.io.XmlUtils;
import com.cognos.rspecupgrade.internal.queryfinder.BeringQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.engine.UpgradeSessionContext;
import com.cognos.rspecupgrade.rsupgrade.internal.exceptions.UpgradeException;
import com.cognos.rspecupgrade.rsupgrade.internal.messages.RspecUpgradeMessage;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification20;
import com.cognos.rspecupgrade.rsupgrade.internal.specification.ReportSpecification50;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.BalticQueryFinder;
import com.cognos.rspecupgrade.rsupgrade.internal.upgradepipeline._10to20.NamespaceContext10x20;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PropertyListAdjuster {
    private Document v4ReportSpec;
    private Locale expressionLocale;

    PropertyListAdjuster(Locale expressionLocale, Document v4ReportSpec) {
        this.expressionLocale = expressionLocale;
        this.v4ReportSpec = v4ReportSpec;
    }

    public void adjustPropertyLists(Document v5ReportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        this.addListPropertyItems(v5ReportSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "listPropertyItems", upgradeSession.getConfiguration());
        this.addPagePropertyLists(v5ReportSpec);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "pagePropertyLists", upgradeSession.getConfiguration());
        this.addLayoutReportExpressions(v5ReportSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "propertyListReportExpressions", upgradeSession.getConfiguration());
        this.addReportVariables(v5ReportSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "propertyListReportVariables", upgradeSession.getConfiguration());
        this.addCrosstabFactCells(v5ReportSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "propertyListCrosstabFactCells", upgradeSession.getConfiguration());
        this.addDrillLinks(v5ReportSpec, upgradeSession);
        XmlUtils.writeIntermediateDocument(v5ReportSpec, "propertyListDrillLinks", upgradeSession.getConfiguration());
        PropertyListAdjuster.removeReferencedDataItems(v5ReportSpec);
    }

    private Document addPagePropertyLists(Document v5Spec) {
        Element report = XmlUtils.getFirstChildElementByName(v5Spec, ReportSpecification20._report);
        if (report == null) {
            return v5Spec;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts == null) {
            return v5Spec;
        }
        NodeList pages = layouts.getElementsByTagName(ReportSpecification20._page);
        int nbPages = pages.getLength();
        for (int pageNb = 0; pageNb < nbPages; ++pageNb) {
            Element propertyList;
            Element page = (Element)pages.item(pageNb);
            if (!page.hasAttribute(ReportSpecification20._refQuery) || (propertyList = XmlUtils.getFirstChildElementByName(page, ReportSpecification20._propertyList)) != null) continue;
            propertyList = v5Spec.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._propertyList);
            page.appendChild(propertyList);
        }
        return v5Spec;
    }

    private void addReportVariables(Document v5Doc, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5Doc, ReportSpecification20._report);
        if (report == null) {
            return;
        }
        Element variables = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._reportVariables);
        if (variables != null) {
            for (Node reportVariableNode = variables.getFirstChild(); reportVariableNode != null; reportVariableNode = reportVariableNode.getNextSibling()) {
                IExpression parseTree;
                Element reportVariable;
                if (reportVariableNode.getNodeType() != 1 || !XmlUtils.getName(reportVariable = (Element)reportVariableNode).equals(ReportSpecification20._reportVariable)) continue;
                Element reportExpression = XmlUtils.getFirstChildElementByName(reportVariable, ReportSpecification20._reportExpression);
                String expression = XmlUtils.getText(reportExpression);
                String variableName = reportVariable.getAttribute(ReportSpecification20._name);
                StringReader reader = new StringReader(expression);
                try {
                    CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
                    parseTree = parser.start();
                }
                catch (CrxParserException ex) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR_2(expression, ex.getLocalizedMessage());
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)reportExpression, 0, message);
                    return;
                }
                Set<NameExpression> refDataItems = GetNames.getNames(parseTree);
                if (refDataItems.isEmpty()) continue;
                this.addVariablePropertyItems(v5Doc, variableName, refDataItems, upgradeSession);
            }
        }
    }

    private void addLayoutReportExpressions(Document v5Doc, UpgradeSessionContext context) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5Doc, ReportSpecification20._report);
        if (report == null) {
            return;
        }
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        if (layouts == null) {
            return;
        }
        this.addLayoutReportExpressions(layouts, context);
    }

    private void addLayoutReportExpressions(Element v5Element, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String localName = XmlUtils.getName(v5Element);
        if (localName.equals(ReportSpecification20._reportVariables)) {
            return;
        }
        if (localName.equals(ReportSpecification20._reportExpression)) {
            IExpression parseTree;
            String expression = XmlUtils.getText(v5Element);
            StringReader reader = new StringReader(expression);
            try {
                CrxParser parser = new CrxParser(reader, this.expressionLocale, upgradeSession.getTranslatedMessages());
                parseTree = parser.start();
            }
            catch (CrxParserException ex) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_UPG_CRX_PARSER_ERROR_2(expression, ex.getLocalizedMessage());
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5Element, 0, message);
                return;
            }
            Set<NameExpression> refDataItems = GetNames.getNames(parseTree);
            if (!refDataItems.isEmpty()) {
                this.addPropertyItemsForContext(v5Element, refDataItems, upgradeSession);
            }
        }
        for (Node child = v5Element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.addLayoutReportExpressions(childElement, upgradeSession);
        }
    }

    private void addVariablePropertyItems(Document v5Doc, String variableName, Set<NameExpression> refDataItems, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element report = XmlUtils.getFirstChildElementByName(v5Doc, ReportSpecification20._report);
        Element layouts = XmlUtils.getFirstChildElementByName(report, ReportSpecification20._layouts);
        this.addVariablePropertyItems(layouts, variableName, refDataItems, upgradeSession);
    }

    private void addVariablePropertyItems(Element fragment, String variableName, Set<NameExpression> refDataItems, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (Node child = fragment.getFirstChild(); child != null; child = child.getNextSibling()) {
            String varName;
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            if (childElement.hasAttribute(ReportSpecification20._refVariable) && (varName = childElement.getAttribute(ReportSpecification20._refVariable)).equals(variableName)) {
                this.addPropertyItemsForContext(childElement, refDataItems, upgradeSession);
                this.addVariablePropertyItemsForListGroup(childElement, refDataItems, upgradeSession);
            }
            this.addVariablePropertyItems(childElement, variableName, refDataItems, upgradeSession);
        }
    }

    private void addVariablePropertyItemsForListGroup(Element refVariableUser, Set<NameExpression> refDataItems, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element listElement = BeringQueryFinder.findRefQueryElement(refVariableUser);
        if (listElement == null || !XmlUtils.getName(listElement).equals(ReportSpecification20._list)) {
            return;
        }
        Element listColumn = XmlUtils.getAncestorOrSelfElement(refVariableUser, ReportSpecification20._listColumn, listElement);
        if (listColumn == null) {
            return;
        }
        Element listGroups = XmlUtils.getFirstChildElementByName(listElement, ReportSpecification20._listGroups);
        if (listGroups == null) {
            return;
        }
        Set<String> dataItemsUsed = this.findDataItems(listColumn);
        for (Node listGroupNode = listGroups.getFirstChild(); listGroupNode != null; listGroupNode = listGroupNode.getNextSibling()) {
            String groupDataItem;
            Element listGroupElement;
            if (!(listGroupNode instanceof Element) || !XmlUtils.getName(listGroupElement = (Element)listGroupNode).equals(ReportSpecification20._listGroup) || !listGroupElement.hasAttribute(ReportSpecification20._refDataItem) || !dataItemsUsed.contains(groupDataItem = listGroupElement.getAttribute(ReportSpecification20._refDataItem))) continue;
            Element context = XmlUtils.getFirstChildElementByName(listGroupElement, ReportSpecification20._propertyList);
            this.addPropertyItemsForContext(context, refDataItems, upgradeSession);
        }
    }

    Set<String> findDataItems(Element elem) {
        HashSet<String> dataItems = new HashSet<String>();
        this.findDataItems(elem, dataItems);
        return dataItems;
    }

    private void findDataItems(Element elem, Set<String> dataItems) {
        if (elem.hasAttribute(ReportSpecification20._refQuery)) {
            return;
        }
        if (elem.hasAttribute(ReportSpecification20._refDataItem)) {
            String v = elem.getAttribute(ReportSpecification20._refDataItem);
            dataItems.add(v);
        }
        for (Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element childElement = (Element)child;
            this.findDataItems(childElement, dataItems);
        }
    }

    private void addPropertyItemsForContext(Element context, Set<NameExpression> refDataItems, UpgradeSessionContext upgradeSession) throws UpgradeException {
        for (NameExpression name : refDataItems) {
            String dataItem = name.getDataItem();
            this.addPropertyItemForContext(context, dataItem, upgradeSession);
        }
    }

    private boolean addPropertyItemForContext(Element context, String refDataItem, UpgradeSessionContext upgradeSession) throws UpgradeException {
        BeringQueryFinder queryFinder = new BeringQueryFinder();
        String queryName = queryFinder.findQueryName(context, refDataItem);
        NameExpression dataItem = new NameExpression();
        dataItem.add(queryName);
        dataItem.add(refDataItem);
        Element propertyList = this.getPropertyList(context, dataItem, upgradeSession);
        if (propertyList == null) {
            return false;
        }
        PropertyListAdjuster.addPropertyItem(propertyList, refDataItem);
        return true;
    }

    private static void addPropertyItem(Element propertyList, String dataItem) {
        Element propertyItem = XmlUtils.getFirstChildElementByNameWithAttributeValue(propertyList, ReportSpecification20._propertyItem, ReportSpecification20._refDataItem, dataItem);
        if (propertyItem == null) {
            Document document = propertyList.getOwnerDocument();
            propertyItem = document.createElementNS(ReportSpecification20.targetNamespace, ReportSpecification20._propertyItem);
            propertyItem.setAttribute(ReportSpecification20._refDataItem, dataItem);
            propertyList.appendChild(propertyItem);
        }
    }

    private static void removeReferencedDataItems(Document v5Spec) {
        NodeList propertyLists = v5Spec.getElementsByTagNameNS(ReportSpecification20.targetNamespace, ReportSpecification20._propertyList);
        int nbLists = propertyLists.getLength();
        for (int i = 0; i < nbLists; ++i) {
            Element propertyList = (Element)propertyLists.item(i);
            PropertyListAdjuster.removeReferencedDataItems(propertyList);
        }
    }

    private static void removeReferencedDataItems(Element propertyList) {
        int i;
        Element layoutElement = (Element)propertyList.getParentNode();
        HashSet<String> refDataItems = new HashSet<String>(100);
        PropertyListAdjuster.findReferencedDataItems(layoutElement, refDataItems, true);
        NodeList propertyItems = propertyList.getChildNodes();
        int nbChildren = propertyItems.getLength();
        Vector<Element> childrenToRemove = new Vector<Element>(nbChildren);
        for (i = 0; i < nbChildren; ++i) {
            String refDataItem;
            Element propertyItem;
            Node child = propertyItems.item(i);
            if (child.getNodeType() != 1 || !XmlUtils.getName(propertyItem = (Element)child).equals(ReportSpecification20._propertyItem) || !refDataItems.contains(refDataItem = propertyItem.getAttribute(ReportSpecification20._refDataItem))) continue;
            childrenToRemove.add(propertyItem);
        }
        nbChildren = childrenToRemove.size();
        for (i = 0; i < nbChildren; ++i) {
            Element propertyItem = (Element)childrenToRemove.get(i);
            propertyList.removeChild(propertyItem);
        }
    }

    private static void findReferencedDataItems(Element layoutElement, Set<String> foundDataItems, boolean firstNode) {
        if (XmlUtils.getName(layoutElement).equals(ReportSpecification20._propertyList)) {
            return;
        }
        if (!firstNode) {
            if (layoutElement.hasAttribute(ReportSpecification20._refQuery)) {
                return;
            }
            Element propertyList = XmlUtils.getFirstChildElementByName(layoutElement, ReportSpecification20._propertyList);
            if (propertyList != null) {
                return;
            }
        }
        if (XmlUtils.getName(layoutElement).equals(ReportSpecification20._masterDetailLinks)) {
            return;
        }
        if (XmlUtils.getName(layoutElement).equals(ReportSpecification20._drillLink)) {
            return;
        }
        if (XmlUtils.getName(layoutElement).equals(ReportSpecification20._sortList)) {
            return;
        }
        if (layoutElement.hasAttribute(ReportSpecification20._refDataItem)) {
            String dataItem = layoutElement.getAttribute(ReportSpecification20._refDataItem);
            String label = XmlUtils.getName(layoutElement);
            if (!label.equals(ReportSpecification20._dataItemLabel)) {
                foundDataItems.add(dataItem);
            }
        }
        NodeList children = layoutElement.getChildNodes();
        int nbChildren = children.getLength();
        for (int i = 0; i < nbChildren; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element childElement = (Element)child;
            PropertyListAdjuster.findReferencedDataItems(childElement, foundDataItems, false);
        }
    }

    private Element getPropertyList(Element context, NameExpression v5Name, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String queryName = v5Name.getQueryName();
        String dataItem = v5Name.getDataItem();
        Element refQueryElem = null;
        boolean findEnclosingRefQuery = true;
        while (context != null && findEnclosingRefQuery) {
            findEnclosingRefQuery = false;
            refQueryElem = BeringQueryFinder.findRefQueryElement(context);
            if (refQueryElem == null || refQueryElem.getAttribute(ReportSpecification20._refQuery).equals(queryName)) continue;
            context = XmlUtils.getParentElement(refQueryElem);
            findEnclosingRefQuery = true;
        }
        while (context != null) {
            Element propertyList;
            Element sibling;
            String contextName = XmlUtils.getName(context);
            if (contextName.equals(ReportSpecification20._listColumnBody)) {
                Element rowSpan = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._listColumnRowSpan);
                if (rowSpan == null) {
                    context = XmlUtils.getParentElement(context);
                    continue;
                }
                String groupDataItem = rowSpan.getAttribute(ReportSpecification20._refDataItem);
                Element list = XmlUtils.getAncestorElement(context, ReportSpecification20._list);
                if (list == null) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_LISTGROUP_FOR_DATAITEM(groupDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, message);
                    return null;
                }
                Element listGroups = XmlUtils.getFirstChildElementByName(list, ReportSpecification20._listGroups);
                if (listGroups == null) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_LISTGROUP_FOR_DATAITEM(groupDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)list, 0, message);
                    return null;
                }
                Element listGroup = XmlUtils.getFirstChildElementByNameWithAttributeValue(listGroups, ReportSpecification20._listGroup, ReportSpecification20._refDataItem, groupDataItem);
                if (listGroup == null) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_LISTGROUP_FOR_DATAITEM(groupDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)listGroups, 0, message);
                    return null;
                }
                context = listGroup;
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabNodeMember)) {
                Element propertyList2;
                if (!refQueryElem.hasAttribute("originalRefQuery")) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_MISSING_ATTRIBUTE_ORIGINAL_REFQUERY();
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)context, 0, message);
                    return null;
                }
                String originalRefQuery = refQueryElem.getAttribute("originalRefQuery");
                String nodeDataItem = context.getAttribute(ReportSpecification20._refDataItem);
                if (dataItem.equals(nodeDataItem)) {
                    propertyList2 = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._propertyList);
                    return propertyList2;
                }
                if (this.areDataItemsInSameLevel(originalRefQuery, dataItem, nodeDataItem)) {
                    propertyList2 = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._propertyList);
                    return propertyList2;
                }
                Element sibling2 = XmlUtils.getPreviousSiblingByName(context, ReportSpecification20._crosstabNodeMember);
                if (sibling2 == null) {
                    context = XmlUtils.getParentElement(context);
                    continue;
                }
                context = sibling2;
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabNestedNodes)) {
                Element parent = XmlUtils.getParentElement(context);
                Element crosstabNodeMembers = XmlUtils.getFirstChildElementByName(parent, ReportSpecification20._crosstabNodeMembers);
                context = this.getLastCrosstabNodeMember(crosstabNodeMembers, upgradeSession);
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabNodeMembers)) {
                context = XmlUtils.getParentElement(context);
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabNode)) {
                sibling = XmlUtils.getPreviousSiblingByName(context, ReportSpecification20._crosstabNode);
                if (sibling == null) {
                    context = XmlUtils.getParentElement(context);
                    continue;
                }
                context = this.getLastCrosstabNodeMember(sibling, upgradeSession);
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabRows) || contextName.equals(ReportSpecification20._crosstabColumns)) {
                sibling = this.getPreviousCrosstabRowsOrColumns(context);
                if (sibling == null) {
                    context = XmlUtils.getParentElement(context);
                    continue;
                }
                context = this.getLastCrosstabNodeMember(sibling, upgradeSession);
                continue;
            }
            if (contextName.equals(ReportSpecification20._crosstabFactCell)) {
                return this.crosstabFactCellPropertyList(context, v5Name);
            }
            if (contextName.equals(ReportSpecification20._pageGroup)) {
                propertyList = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._propertyList);
                if (propertyList != null) {
                    return propertyList;
                }
                context = XmlUtils.getParentElement(context);
                continue;
            }
            if (contextName.equals(ReportSpecification20._page)) {
                NodeList pageGroupList;
                int nbPageGroups;
                Element pageGroups;
                propertyList = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._propertyList);
                if (propertyList != null) {
                    return propertyList;
                }
                Element newContext = null;
                Element parent = XmlUtils.getParentElement(context);
                String parentName = XmlUtils.getName(parent);
                if (ReportSpecification20._detailPages.equals(parentName) && ReportSpecification20._pageSet.equals(parentName = XmlUtils.getName(parent = XmlUtils.getParentElement(parent))) && (pageGroups = XmlUtils.getFirstChildElementByName(parent, ReportSpecification20._pageGroups)) != null && (nbPageGroups = (pageGroupList = XmlUtils.getChildElementsByName(pageGroups, ReportSpecification20._pageGroup)).getLength()) > 0) {
                    newContext = (Element)pageGroupList.item(nbPageGroups - 1);
                }
                if (newContext != null) {
                    context = newContext;
                    continue;
                }
                if (context.hasAttribute(ReportSpecification20._refQuery)) {
                    context = null;
                    continue;
                }
                context = XmlUtils.getParentElement(context);
                continue;
            }
            propertyList = XmlUtils.getFirstChildElementByName(context, ReportSpecification20._propertyList);
            if (propertyList != null) {
                return propertyList;
            }
            if (context == refQueryElem) {
                return null;
            }
            context = XmlUtils.getParentElement(context);
        }
        return null;
    }

    private Element getLastCrosstabNodeMember(Element base, UpgradeSessionContext upgradeSession) throws UpgradeException {
        String baseName = XmlUtils.getName(base);
        while (!baseName.equals(ReportSpecification20._crosstabNodeMember)) {
            if (baseName.equals(ReportSpecification20._crosstabNodeMembers)) {
                base = XmlUtils.getLastChildElementByName(base, ReportSpecification20._crosstabNodeMember);
            } else if (baseName.equals(ReportSpecification20._crosstabNode)) {
                Element nested = XmlUtils.getFirstChildElementByName(base, ReportSpecification20._crosstabNestedNodes);
                base = nested != null ? nested : XmlUtils.getFirstChildElementByName(base, ReportSpecification20._crosstabNodeMembers);
            } else if (baseName.equals(ReportSpecification20._crosstabNestedNodes) || baseName.equals(ReportSpecification20._crosstabColumns) || baseName.equals(ReportSpecification20._crosstabRows)) {
                base = XmlUtils.getLastChildElement(base);
            } else {
                String msg = upgradeSession.getTranslatedMessages().getString(RspecUpgradeMessage.RSU_SPC_INTERNAL_ERROR_CROSSTAB_PROPERTY_LIST_BAD_ELEMENT(baseName));
                throw new UpgradeException(msg);
            }
            baseName = XmlUtils.getName(base);
        }
        return base;
    }

    private Element getPreviousCrosstabRowsOrColumns(Element base) {
        Element result = XmlUtils.getPreviousSiblingElement(base);
        while (result != null && !XmlUtils.getName(result).equals(ReportSpecification20._crosstabRows) && !XmlUtils.getName(result).equals(ReportSpecification20._crosstabColumns)) {
            result = XmlUtils.getPreviousSiblingElement(result);
        }
        return result;
    }

    private boolean areDataItemsInSameLevel(String v4QueryName, String aRefDataItem, String bRefDataItem) throws UpgradeException {
        Element v4QueryElement = BalticQueryFinder.findQueryElement(this.v4ReportSpec, v4QueryName);
        NodeList levelNodeList = v4QueryElement.getElementsByTagName("level");
        int nbLevels = levelNodeList.getLength();
        for (int levelNb = 0; levelNb < nbLevels; ++levelNb) {
            Element level = (Element)levelNodeList.item(levelNb);
            if (!this.levelDefinesDataItem(level, aRefDataItem) || !this.levelDefinesDataItem(level, bRefDataItem)) continue;
            return true;
        }
        return false;
    }

    private boolean levelDefinesDataItem(Element v4Level, String name) {
        NodeList dataItemNodeList = v4Level.getElementsByTagName("dataItem");
        int nbDataItemNodes = dataItemNodeList.getLength();
        for (int dataItemNb = 0; dataItemNb < nbDataItemNodes; ++dataItemNb) {
            Element dataItem = (Element)dataItemNodeList.item(dataItemNb);
            String dataItemName = dataItem.getAttribute("name");
            if (!name.equals(dataItemName)) continue;
            return true;
        }
        NodeList itemNodeList = v4Level.getElementsByTagName("item");
        int nbItemNodes = itemNodeList.getLength();
        for (int itemNb = 0; itemNb < nbItemNodes; ++itemNb) {
            String refItem;
            String alias;
            Element item = (Element)itemNodeList.item(itemNb);
            if (!(item.hasAttribute("alias") ? name.equals(alias = item.getAttribute("alias")) : name.equals(refItem = item.getAttribute("refItem")))) continue;
            return true;
        }
        return false;
    }

    private void addCrosstabFactCells(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList factCellList = v5.getElementsByTagName(ReportSpecification20._crosstabFactCell);
        int nbFactCells = factCellList.getLength();
        for (int factCellNb = 0; factCellNb < nbFactCells; ++factCellNb) {
            Element factCell = (Element)factCellList.item(factCellNb);
            Element crosstab = (Element)factCell.getParentNode();
            String originalQuery = crosstab.getAttribute("originalRefQuery");
            Element balticQuery = BalticQueryFinder.findQueryElement(this.v4ReportSpec, originalQuery);
            if (balticQuery == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_PROPERTY_ITEM_ADDED_FOR_CROSSTABFACTCELL_0();
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)factCell, 0, message);
                continue;
            }
            Set<String> dataItems = this.findDataItems(factCell);
            for (String refDataItem : dataItems) {
                Element columns;
                String refKey = BalticQueryFinder.findLevelFirstKeyForItem(this.v4ReportSpec, balticQuery, refDataItem);
                if (refKey == null) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_PROPERTY_ITEM_ADDED_FOR_CROSSTABFACTCELL_1(refDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)factCell, 0, message);
                    continue;
                }
                Element crosstabNode = null;
                Element rows = XmlUtils.getFirstChildElementByName(crosstab, ReportSpecification20._crosstabRows);
                if (rows != null) {
                    crosstabNode = this.findCrosstabNodeMember(rows, refKey);
                }
                if (crosstabNode == null && (columns = XmlUtils.getFirstChildElementByName(crosstab, ReportSpecification20._crosstabColumns)) != null) {
                    crosstabNode = this.findCrosstabNodeMember(columns, refKey);
                }
                if (crosstabNode == null) {
                    RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_NO_PROPERTY_ITEM_ADDED_FOR_CROSSTABFACTCELL_1(refDataItem);
                    upgradeSession.getUpgradeNotes().addUpgradeNote((Node)factCell, 0, message);
                    continue;
                }
                Element propertyList = XmlUtils.getFirstChildElementByName(crosstabNode, ReportSpecification20._propertyList);
                PropertyListAdjuster.addPropertyItem(propertyList, refDataItem);
            }
        }
    }

    private void addDrillLinks(Document v5, UpgradeSessionContext upgradeSession) throws UpgradeException {
        NodeList drillSourceNodes = v5.getElementsByTagName(ReportSpecification20._drillSourceContext);
        int nbDrillSourceNodes = drillSourceNodes.getLength();
        for (int drillSourceNodeNb = 0; drillSourceNodeNb < nbDrillSourceNodes; ++drillSourceNodeNb) {
            Element drillSource = (Element)drillSourceNodes.item(drillSourceNodeNb);
            Element dataItemContext = XmlUtils.getFirstChildElementByName(drillSource, ReportSpecification20._dataItemContext);
            if (dataItemContext == null) continue;
            String refDataItem = dataItemContext.getAttribute(ReportSpecification20._refDataItem);
            this.addPropertyItemForContext(dataItemContext, refDataItem, upgradeSession);
        }
    }

    private Element findCrosstabNodeMember(Element crosstabNodeListType, String dataItem) {
        NodeList crosstabNodes = XmlUtils.getChildElementsByName(crosstabNodeListType, ReportSpecification20._crosstabNode);
        int nbCrosstabNodes = crosstabNodes.getLength();
        for (int crosstabNodeNb = 0; crosstabNodeNb < nbCrosstabNodes; ++crosstabNodeNb) {
            Element crosstabNodeMember;
            Element crosstabNode = (Element)crosstabNodes.item(crosstabNodeNb);
            Element crosstabNodeMembers = XmlUtils.getFirstChildElementByName(crosstabNode, ReportSpecification20._crosstabNodeMembers);
            NodeList crosstabNodeMemberList = XmlUtils.getChildElementsByName(crosstabNodeMembers, ReportSpecification20._crosstabNodeMember);
            int nbCrosstabNodeMember = crosstabNodeMemberList.getLength();
            for (int crosstabNodeMemberNb = 0; crosstabNodeMemberNb < nbCrosstabNodeMember; ++crosstabNodeMemberNb) {
                crosstabNodeMember = (Element)crosstabNodeMemberList.item(crosstabNodeMemberNb);
                String refDataItem = crosstabNodeMember.getAttribute(ReportSpecification20._refDataItem);
                if (!refDataItem.equals(dataItem)) continue;
                return crosstabNodeMember;
            }
            Element crosstabNestedNodes = XmlUtils.getFirstChildElementByName(crosstabNode, ReportSpecification20._crosstabNestedNodes);
            if (crosstabNestedNodes == null || (crosstabNodeMember = this.findCrosstabNodeMember(crosstabNestedNodes, dataItem)) == null) continue;
            return crosstabNodeMember;
        }
        return null;
    }

    private Element crosstabFactCellPropertyList(Element crosstabFactCell, NameExpression name) throws UpgradeException {
        String refLevel;
        Element balticColumnEdge;
        Element crosstab = XmlUtils.getAncestorElement(crosstabFactCell, ReportSpecification20._crosstab);
        String originalRefQuery = crosstab.getAttribute("originalRefQuery");
        Document reportSpec = XmlUtils.getOwnerDoc(crosstabFactCell);
        Element report = XmlUtils.getFirstChildElementByName(reportSpec, ReportSpecification20._report);
        Element balticQuerySet = XmlUtils.getFirstChildElementByName(report, "querySet");
        Element balticQuery = XmlUtils.getFirstChildElementByNameWithAttributeValue(balticQuerySet, "BIQuery", "name", originalRefQuery);
        Element summary = XmlUtils.getFirstChildElementByName(balticQuery, "summary");
        if (summary == null) {
            return null;
        }
        Element level = null;
        boolean isRow = true;
        String itemName = name.getDataItem();
        Element balticRowEdge = XmlUtils.getFirstChildElementByName(summary, "rowEdge");
        if (balticRowEdge != null) {
            level = this.findBalticLevelWithItem(balticRowEdge, itemName);
            isRow = true;
        }
        if (level == null && (balticColumnEdge = XmlUtils.getFirstChildElementByName(summary, "columnEdge")) != null) {
            level = this.findBalticLevelWithItem(balticColumnEdge, itemName);
            isRow = false;
        }
        if (level == null) {
            return null;
        }
        Element crosstabRowsOrColumns = isRow ? XmlUtils.getFirstChildElementByName(crosstab, ReportSpecification20._crosstabRows) : XmlUtils.getFirstChildElementByName(crosstab, ReportSpecification20._crosstabColumns);
        Element crosstabNodeMember = XmlUtils.getNamedElementWithAttributeValue(crosstabRowsOrColumns, ReportSpecification20._crosstabNodeMember, "originalRefLevel", refLevel = level.getAttribute("refLevel"));
        if (crosstabNodeMember == null) {
            return null;
        }
        Element propertyList = XmlUtils.getFirstChildElementByName(crosstabNodeMember, ReportSpecification20._propertyList);
        return propertyList;
    }

    private Element findBalticLevelWithItem(Element edge, String itemName) {
        NodeList levelList = XmlUtils.getChildElementsByName(edge, "level");
        int nbLevels = levelList.getLength();
        for (int i = 0; i < nbLevels; ++i) {
            Element level = (Element)levelList.item(i);
            Element item = XmlUtils.getFirstChildElementByNameWithAttributeValue(level, "item", "refItem", itemName);
            if (item == null) continue;
            return level;
        }
        return null;
    }

    private void addListPropertyItems(Document v5ReportSpec, UpgradeSessionContext upgradeSession) throws UpgradeException {
        Element reportElement = XmlUtils.getRoot(v5ReportSpec);
        if (reportElement == null) {
            return;
        }
        Element layoutsElement = XmlUtils.getFirstChildElementByName(reportElement, ReportSpecification20._layouts);
        if (layoutsElement == null) {
            return;
        }
        NodeList listElements = layoutsElement.getElementsByTagName(ReportSpecification20._page);
        this.addFactListPropertyItems(listElements, upgradeSession);
        listElements = this.getNamedElementsThatDoNotShareAQuery(layoutsElement, ReportSpecification20._pageSet);
        this.addFactListPropertyItems(listElements, upgradeSession);
        listElements = layoutsElement.getElementsByTagName(ReportSpecification20._list);
        this.addListPropertyItems(listElements, upgradeSession);
        listElements = layoutsElement.getElementsByTagName(ReportSpecification20._repeaterTable);
        this.addListPropertyItems(listElements, upgradeSession);
        listElements = layoutsElement.getElementsByTagName(ReportSpecification20._selectValue);
        this.addListPropertyItems(listElements, upgradeSession);
        listElements = layoutsElement.getElementsByTagName(ReportSpecification20._selectWithSearch);
        this.addListPropertyItems(listElements, upgradeSession);
    }

    private void addListPropertyItems(NodeList v5ListElements, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nb = v5ListElements.getLength();
        for (int i = 0; i < nb; ++i) {
            Element v5ListElement = (Element)v5ListElements.item(i);
            Element v5PropertyList = XmlUtils.getFirstChildElementByName(v5ListElement, ReportSpecification20._propertyList);
            String shareResultSetValue = v5ListElement.getAttribute(ReportSpecification50._shareResultSet);
            boolean shareResultSet = shareResultSetValue.equals(ReportSpecification20._true);
            if (shareResultSet || v5PropertyList == null || !v5ListElement.hasAttribute("originalRefQuery")) continue;
            String origRefQuery = v5ListElement.getAttribute("originalRefQuery");
            Element v4Cube = BalticQueryFinder.findCube(this.v4ReportSpec, origRefQuery);
            if (v4Cube == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CUBE_NOT_FOUND(origRefQuery);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5ListElement, 0, message);
                continue;
            }
            this.addPropertyItemsForCube(v5PropertyList, v4Cube);
        }
    }

    private void addFactListPropertyItems(NodeList v5ListElements, UpgradeSessionContext upgradeSession) throws UpgradeException {
        int nb = v5ListElements.getLength();
        for (int i = 0; i < nb; ++i) {
            Element v5ListElement = (Element)v5ListElements.item(i);
            Element v5PropertyList = XmlUtils.getFirstChildElementByName(v5ListElement, ReportSpecification20._propertyList);
            if (v5PropertyList == null || !v5ListElement.hasAttribute("originalRefQuery")) continue;
            String origRefQuery = v5ListElement.getAttribute("originalRefQuery");
            Element v4Cube = BalticQueryFinder.findCube(this.v4ReportSpec, origRefQuery);
            if (v4Cube == null) {
                RspecUpgradeMessage message = RspecUpgradeMessage.RSU_SPC_CUBE_NOT_FOUND(origRefQuery);
                upgradeSession.getUpgradeNotes().addUpgradeNote((Node)v5ListElement, 0, message);
                continue;
            }
            Element factList = XmlUtils.getFirstChildElementByName(v4Cube, "factList");
            if (factList == null) continue;
            this.addPropertyItemsForFactList(v5PropertyList, factList);
        }
    }

    private void addPropertyItemsForCube(Element v5PropertyList, Element v4Cube) throws UpgradeException {
        try {
            String path = "./baltic:factList/baltic:item/@alias";
            NodeList contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
            path = "./baltic:factList/baltic:item[not(@alias)]/@refItem";
            contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
            path = "./baltic:factList/baltic:dataItem/@name";
            contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
            path = "./baltic:dimension/baltic:level/baltic:item/@alias";
            contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
            path = "./baltic:dimension/baltic:level/baltic:item[not(@alias)]/@refItem";
            contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
            path = "./baltic:dimension/baltic:level/baltic:dataItem/@name";
            contentNodes = XmlUtils.selectNodeList(v4Cube, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private void addPropertyItemsForFactList(Element v5PropertyList, Element v4FactList) throws UpgradeException {
        try {
            String path = "./baltic:item/@alias | ./baltic:item[not(@alias)]/@refItem | ./baltic:dataItem/@name";
            NodeList contentNodes = XmlUtils.selectNodeList(v4FactList, path, NamespaceContext10x20.instance);
            PropertyListAdjuster.addPropertyItems(v5PropertyList, contentNodes);
        }
        catch (XPathExpressionException e) {
            UpgradeException.throwNestedException(e);
        }
    }

    private static void addPropertyItems(Element propertyList, NodeList contentNodes) throws UpgradeException {
        int nb = contentNodes.getLength();
        for (int i = 0; i < nb; ++i) {
            Attr node = (Attr)contentNodes.item(i);
            String dataItem = node.getValue();
            PropertyListAdjuster.addPropertyItem(propertyList, dataItem);
        }
    }

    private NodeList getNamedElementsThatDoNotShareAQuery(Element layoutsElement, String elementName) {
        NodeListListImpl notSharedList = new NodeListListImpl();
        NodeList namedElementList = layoutsElement.getElementsByTagName(elementName);
        int nb = namedElementList.getLength();
        for (int i = 0; i < nb; ++i) {
            Element pageSet = (Element)namedElementList.item(i);
            String pageSetQuery = pageSet.getAttribute(ReportSpecification20._refQuery);
            if (this.isQueryShared(pageSetQuery, pageSet)) continue;
            notSharedList.add(pageSet);
        }
        return notSharedList;
    }

    private boolean isQueryShared(String ancestorQueryName, Element ancestorElement) {
        NodeList childrenList = XmlUtils.getChildElements(ancestorElement);
        int nb = childrenList.getLength();
        for (int i = 0; i < nb; ++i) {
            String queryName;
            Element childElement = (Element)childrenList.item(i);
            boolean hasRefQuery = childElement.hasAttribute(ReportSpecification20._refQuery);
            String childName = XmlUtils.getName(childElement);
            if (!(hasRefQuery && !childName.equals(ReportSpecification20._page) ? (childName.equals(ReportSpecification20._list) || childName.equals(ReportSpecification20._repeater) || childName.equals(ReportSpecification20._repeaterTable) || childName.equals(ReportSpecification20._pageSet)) && ancestorQueryName.equals(queryName = childElement.getAttribute(ReportSpecification20._refQuery)) : childElement.hasChildNodes() && this.isQueryShared(ancestorQueryName, childElement))) continue;
            return true;
        }
        return false;
    }
}

